/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.chunk;

import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.util.noise.SimpleDensityFunction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class ModernBetaChunkNoiseSampler {
    private static final int HEIGHT_OFFSET = -8;
    private final ChunkProvider chunkProvider;

    public static NoiseChunk create(ChunkAccess chunk, RandomState noiseConfig, NoiseGeneratorSettings chunkGeneratorSettings, Aquifer.FluidPicker fluidLevelSampler, ChunkProvider chunkProvider) {
        NoiseSettings shapeConfig = chunkGeneratorSettings.noiseSettings().clampToHeightAccessor((LevelHeightAccessor)chunk);
        ChunkPos chunkPos = chunk.getPos();
        int horizontalSize = 16 / shapeConfig.getCellWidth();
        return new ModernBetaChunkNoiseSampler(chunkProvider).createSampler(horizontalSize, noiseConfig, chunkPos.getMinBlockX(), chunkPos.getMinBlockZ(), shapeConfig, SimpleDensityFunction.INSTANCE, chunkGeneratorSettings, fluidLevelSampler, Blender.empty());
    }

    private ModernBetaChunkNoiseSampler(ChunkProvider chunkProvider) {
        this.chunkProvider = chunkProvider;
    }

    private SamplerImpl createSampler(int horizontalSize, RandomState noiseConfig, int startX, int startZ, NoiseSettings shapeConfig, DensityFunctions.BeardifierOrMarker beardifying, NoiseGeneratorSettings settings, Aquifer.FluidPicker fluidLevelSampler, Blender blender) {
        return new SamplerImpl(horizontalSize, noiseConfig, startX, startZ, shapeConfig, beardifying, settings, fluidLevelSampler, blender);
    }

    private class SamplerImpl
    extends NoiseChunk {
        private SamplerImpl(int horizontalSize, RandomState noiseConfig, int startX, int startZ, NoiseSettings shapeConfig, DensityFunctions.BeardifierOrMarker beardifying, NoiseGeneratorSettings settings, Aquifer.FluidPicker fluidLevelSampler, Blender blender) {
            super(horizontalSize, noiseConfig, startX, startZ, shapeConfig, beardifying, settings, fluidLevelSampler, blender);
        }

        public int preliminarySurfaceLevel(int x, int z) {
            int n;
            ChunkProvider chunkProvider = ModernBetaChunkNoiseSampler.this.chunkProvider;
            if (chunkProvider instanceof ChunkProviderNoise) {
                ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
                n = noiseChunkProvider.getHeight(null, x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
            } else {
                n = ModernBetaChunkNoiseSampler.this.chunkProvider.getHeight(null, x, z, Heightmap.Types.OCEAN_FLOOR_WG);
            }
            int height = n;
            return height + -8;
        }
    }
}

