/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.BiomePredicate;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.BiomePredicateType;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.util.StringRepresentable;

public record InRangeBiomePredicate(int centerX, int centerZ, int radiusX, int radiusZ, boolean evenSize, Shape shape) implements BiomePredicate
{
    public static final MapCodec<InRangeBiomePredicate> CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)Codec.INT.fieldOf("centerX").orElse((Object)0).forGetter(InRangeBiomePredicate::centerX), (App)Codec.INT.fieldOf("centerZ").orElse((Object)0).forGetter(InRangeBiomePredicate::centerZ), (App)Codec.INT.fieldOf("radiusX").forGetter(InRangeBiomePredicate::radiusX), (App)Codec.INT.fieldOf("radiusZ").forGetter(InRangeBiomePredicate::radiusZ), (App)Codec.BOOL.fieldOf("evenSize").orElse((Object)false).forGetter(InRangeBiomePredicate::evenSize), (App)StringRepresentable.fromEnum(Shape::values).fieldOf("shape").forGetter(InRangeBiomePredicate::shape)).apply((Applicative)instance, InRangeBiomePredicate::new));

    @Override
    public BiomePredicateType<?> getType() {
        return BiomePredicateType.IN_RANGE;
    }

    @Override
    public boolean matches(ExtendedBiomeId biome, Layer layer, Supplier<LayerRandom> randomSupplier, int x, int z) {
        if (this.evenSize) {
            if (x - this.centerX < 0) {
                ++x;
            }
            if (z - this.centerZ < 0) {
                ++z;
            }
        }
        double radiusX = this.radiusX - 1;
        double localX = x - this.centerX;
        if (radiusX <= 0.0) {
            localX *= Double.MAX_VALUE;
        } else {
            if (this.shape == Shape.CIRCLE) {
                radiusX += 0.5;
            }
            localX /= radiusX;
        }
        double radiusZ = this.radiusZ - 1;
        double localZ = z - this.centerZ;
        if (radiusZ <= 0.0) {
            localZ *= Double.MAX_VALUE;
        } else {
            if (this.shape == Shape.CIRCLE) {
                radiusZ += 0.5;
            }
            localZ /= radiusZ;
        }
        return Math.abs(localX) <= 1.0 && Math.abs(localZ) <= 1.0 && this.shape.containsPoint(localX, localZ);
    }

    public static enum Shape implements StringRepresentable
    {
        CIRCLE("circle", (x, z) -> x * x + z * z <= 1.0),
        RECTANGLE("rectangle", (x, z) -> true),
        DIAMOND("diamond", (x, z) -> Math.abs(x) + Math.abs(z) <= 1.0);

        private final String id;
        private final DistancePredicate predicate;

        private Shape(String id, DistancePredicate predicate) {
            this.id = id;
            this.predicate = predicate;
        }

        public String getSerializedName() {
            return this.id;
        }

        public boolean containsPoint(double x, double z) {
            return this.predicate.apply(x, z);
        }

        @FunctionalInterface
        public static interface DistancePredicate {
            public boolean apply(double var1, double var3);
        }
    }
}

