/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.LayerTarget;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;

public class WeightedPoolLayer
extends Layer {
    public static final MapCodec<WeightedPoolLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> WeightedPoolLayer.fillLayerFields(instance).and((App)SimpleWeightedRandomList.wrappedCodec(LayerTarget.CODEC).fieldOf("targets").forGetter(layer -> layer.targets)).apply((Applicative)instance, WeightedPoolLayer::new));
    private final SimpleWeightedRandomList<LayerTarget> targets;
    private transient SimpleWeightedRandomList<LayerTarget.Configured> configuredTargets;

    public WeightedPoolLayer(String id, long seed, SimpleWeightedRandomList<LayerTarget> targets) {
        super(id, seed);
        this.targets = targets;
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.WEIGHTED_POOL;
    }

    @Override
    public void configure(Function<String, Layer> layerMap) {
        SimpleWeightedRandomList.Builder poolBuilder = SimpleWeightedRandomList.builder();
        for (WeightedEntry.Wrapper entry : this.targets.unwrap()) {
            poolBuilder.add((Object)((LayerTarget)VersionCompat.getWeightedValue(entry)).configure(layerMap), entry.getWeight().asInt());
        }
        this.configuredTargets = poolBuilder.build();
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        return VersionCompat.accessPool(this.configuredTargets, this.getRandom(x, z)).sample(x, z);
    }

    @Override
    protected List<Layer> getParents() {
        return this.configuredTargets.unwrap().stream().map(VersionCompat::getWeightedValue).map(LayerTarget.Configured::asLayer).flatMap(Optional::stream).toList();
    }

    @Override
    protected void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
        this.configuredTargets.unwrap().stream().map(VersionCompat::getWeightedValue).forEach(target -> target.addPossibleBiomes(biomes));
    }
}

