/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.LayerTarget;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.SingleParentLayer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.BiomePredicate;
import mod.bluestaggo.modernerbeta.util.VersionCompat;

public class ConditionalOverlayLayer
extends SingleParentLayer {
    public static final MapCodec<ConditionalOverlayLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> ConditionalOverlayLayer.fillSingleParentLayerFields(instance).and(instance.group((App)BiomePredicate.BASE_CODEC.fieldOf("predicate").forGetter(layer -> layer.predicate), (App)LayerTarget.CODEC.fieldOf("onMatch").forGetter(layer -> layer.onMatch), (App)LayerTarget.CODEC.fieldOf("otherwise").forGetter(layer -> layer.otherwise))).apply((Applicative)instance, ConditionalOverlayLayer::new));
    private final BiomePredicate predicate;
    private final LayerTarget onMatch;
    private final LayerTarget otherwise;
    private transient LayerTarget.Configured onMatchConfigured;
    private transient LayerTarget.Configured otherwiseConfigured;

    public ConditionalOverlayLayer(String id, long seed, String parent, BiomePredicate predicate, LayerTarget onMatch, LayerTarget otherwise) {
        super(id, seed, parent);
        this.predicate = predicate;
        this.onMatch = onMatch;
        this.otherwise = otherwise;
    }

    public static ConditionalOverlayLayer mushroomIslands() {
        return new ConditionalOverlayLayer("land", 5L, "land", BiomePredicate.of(ExtendedBiomeId.OCEAN).and(BiomePredicate.diagonalInterior()).and(BiomePredicate.oneIn(100)), LayerTarget.biome(ExtendedBiomeId.MUSHROOM_ISLAND), LayerTarget.none());
    }

    @Override
    public void configure(Function<String, Layer> layerMap) {
        super.configure(layerMap);
        this.onMatchConfigured = this.onMatch.configure(layerMap);
        this.otherwiseConfigured = this.otherwise.configure(layerMap);
        if (this.onMatchConfigured.isEquivalentToOrNull(this.parentLayer)) {
            this.onMatchConfigured = null;
        }
        if (this.otherwiseConfigured.isEquivalentToOrNull(this.parentLayer)) {
            this.otherwiseConfigured = null;
        }
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.CONDITIONAL_OVERLAY;
    }

    @Override
    protected List<Layer> getParents() {
        ImmutableList.Builder parents = ImmutableList.builder();
        parents.add((Object)this.parentLayer);
        if (this.onMatchConfigured != null) {
            this.onMatchConfigured.asLayer().ifPresent(arg_0 -> ((ImmutableList.Builder)parents).add(arg_0));
        }
        if (this.otherwiseConfigured != null) {
            this.otherwiseConfigured.asLayer().ifPresent(arg_0 -> ((ImmutableList.Builder)parents).add(arg_0));
        }
        return parents.build();
    }

    @Override
    protected void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
        if (this.onMatchConfigured != null && !(this.onMatchConfigured instanceof LayerTarget.Configured.OfLayer)) {
            this.onMatchConfigured.addPossibleBiomes(biomes);
        }
        if (this.otherwiseConfigured != null && !(this.otherwiseConfigured instanceof LayerTarget.Configured.OfLayer)) {
            this.otherwiseConfigured.addPossibleBiomes(biomes);
        }
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        LayerTarget.Configured target;
        ExtendedBiomeId biome = this.parentLayer.sample(x, z);
        LayerTarget.Configured configured = target = this.predicate.matches(biome, this.parentLayer, (Supplier<LayerRandom>)Suppliers.memoize(() -> this.getRandom(x, z)), x, z) ? this.onMatchConfigured : this.otherwiseConfigured;
        if (target == null) {
            return biome;
        }
        ExtendedBiomeId output = target.sample(x, z);
        if (ExtendedBiomeId.NULL.equals(output)) {
            return biome;
        }
        return output;
    }
}

