/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Set;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomes;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.SingleParentLayer;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class AddLandLayer
extends SingleParentLayer {
    public static final MapCodec<AddLandLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(layer -> layer.id), (App)Codec.LONG.fieldOf("seed").orElse((Object)0L).forGetter(layer -> layer.seed), (App)Codec.STRING.fieldOf("parent").forGetter(layer -> layer.parent), (App)Codec.BOOL.fieldOf("betaShape").orElse((Object)false).forGetter(layer -> layer.betaShape), (App)ExtendedBiomeId.CODEC.fieldOf("ocean").orElse((Object)ExtendedBiomeId.OCEAN).forGetter(layer -> layer.ocean), (App)ExtendedBiomeId.CODEC.fieldOf("land").orElse((Object)ExtendedBiomeId.PLAINS).forGetter(layer -> layer.land), (App)Codec.unboundedMap(ExtendedBiomeId.CODEC, ExtendedBiomeId.CODEC).fieldOf("biomeSpecificOceans").orElse(Map.of()).forGetter(layer -> layer.biomeSpecificOceans), (App)Codec.INT.fieldOf("landChance").orElse((Object)3).forGetter(layer -> layer.landChance), (App)Codec.INT.fieldOf("oceanChance").orElse((Object)5).forGetter(layer -> layer.oceanChance)).apply((Applicative)instance, AddLandLayer::new));
    private final boolean betaShape;
    private final ExtendedBiomeId ocean;
    private final ExtendedBiomeId land;
    private final Map<ExtendedBiomeId, ExtendedBiomeId> biomeSpecificOceans;
    private final int landChance;
    private final int oceanChance;

    public AddLandLayer(String id, long seed, String parent, boolean betaShape, ExtendedBiomeId ocean, ExtendedBiomeId land, Map<ExtendedBiomeId, ExtendedBiomeId> biomeSpecificOceans) {
        this(id, seed, parent, betaShape, ocean, land, biomeSpecificOceans, 3, 5);
    }

    public AddLandLayer(String id, long seed, String parent, boolean betaShape, ExtendedBiomeId ocean, ExtendedBiomeId land, Map<ExtendedBiomeId, ExtendedBiomeId> biomeSpecificOceans, int landChance, int oceanChance) {
        super(id, seed, parent);
        this.betaShape = betaShape;
        this.ocean = ocean;
        this.land = land;
        this.biomeSpecificOceans = biomeSpecificOceans;
        this.landChance = landChance;
        this.oceanChance = oceanChance;
    }

    public static AddLandLayer forIslandScaleBeta(String id, long seed, String parent) {
        return new AddLandLayer(id, seed, parent, true, ExtendedBiomeId.OCEAN, ExtendedBiomeId.PLAINS, Map.of());
    }

    public static AddLandLayer forIslandScale(String id, long seed, String parent) {
        return new AddLandLayer(id, seed, parent, false, ExtendedBiomeId.OCEAN, ExtendedBiomeId.PLAINS, Map.of(ExtendedBiomeId.SNOWY_PLAINS, ExtendedBiomeId.FROZEN_OCEAN));
    }

    public static AddLandLayer forIslandScaleMajor(String id, long seed, String parent) {
        return new AddLandLayer(id, seed, parent, false, ExtendedBiomeId.OCEAN, ExtendedBiomeId.PLAINS, Map.of(ExtendedBiomeId.CLIMATE_SNOWY, ExtendedBiomeId.CLIMATE_SNOWY));
    }

    public static AddLandLayer forBeta(String id, long seed, String parent) {
        return new AddLandLayer(id, seed, parent, true, ExtendedBiomeId.OCEAN, ExtendedBiomeId.of(ModernBetaBiomes.LATE_BETA_PLAINS), Map.of());
    }

    public static AddLandLayer forEarlyRelease(String id, long seed, String parent, ExtendedBiomeId icePlains) {
        return new AddLandLayer(id, seed, parent, false, ExtendedBiomeId.OCEAN, ExtendedBiomeId.of(ModernBetaBiomes.LATE_BETA_PLAINS), Map.of(icePlains, ExtendedBiomeId.FROZEN_OCEAN));
    }

    public static AddLandLayer forMajorRelease(String id, long seed, String parent) {
        return new AddLandLayer(id, seed, parent, false, ExtendedBiomeId.OCEAN, ExtendedBiomeId.PLAINS, Map.of(ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.FOREST), ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.FOREST)));
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.ADD_LAND;
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        LayerRandom random;
        ExtendedBiomeId base = this.parentLayer.sample(x, z);
        ExtendedBiomeId[] neighbors = this.parentLayer.sampleDiagonalNeighbors(x, z);
        if (base.equals(this.ocean) && !AddLandLayer.allNeighborsEqual(neighbors, this.ocean)) {
            boolean addLand;
            int landSampleChance = 1;
            ExtendedBiomeId sampledLand = this.land;
            LayerRandom random2 = this.getRandom(x, z);
            if (this.betaShape) {
                addLand = random2.nextInt(this.landChance) == this.landChance - 1;
            } else {
                for (ExtendedBiomeId neighbor : neighbors) {
                    if (neighbor.equals(this.ocean) || random2.nextInt(landSampleChance++) != 0) continue;
                    sampledLand = neighbor;
                }
                addLand = random2.nextInt(this.landChance) == 0;
            }
            return addLand ? sampledLand : this.biomeSpecificOceans.getOrDefault(sampledLand, this.ocean);
        }
        if ((this.betaShape ? base.equals(this.land) && !AddLandLayer.allNeighborsEqual(neighbors, this.land) : !base.equals(this.ocean) && AddLandLayer.neighborsContain(neighbors, this.ocean)) && (random = this.getRandom(x, z)).nextInt(this.oceanChance) == (this.betaShape ? this.oceanChance - 1 : 0)) {
            return this.biomeSpecificOceans.getOrDefault(base, this.ocean);
        }
        return base;
    }

    @Override
    protected void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
        biomes.add(this.ocean);
        biomes.add(this.land);
        for (Map.Entry<ExtendedBiomeId, ExtendedBiomeId> entry : this.biomeSpecificOceans.entrySet()) {
            biomes.add(entry.getKey());
            biomes.add(entry.getValue());
        }
    }
}

