/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider.fractal.intlayers;

import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.intlayers.IntLayer;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.mixin.BiomeAccessor;
import net.minecraft.core.HolderGetter;
import net.minecraft.world.level.biome.Biome;

public class IntClimateSampleLayer
extends IntLayer {
    private final Layer biomeLayer;
    private final boolean downfall;
    private final IntLayer parent;
    private final int mixLevel;

    public IntClimateSampleLayer(Layer biomeLayer, boolean downfall) {
        this(biomeLayer, downfall, null, 0);
    }

    public IntClimateSampleLayer(Layer biomeLayer, boolean downfall, IntLayer parent, int mixLevel) {
        super(0L);
        this.biomeLayer = biomeLayer;
        this.downfall = downfall;
        this.parent = parent;
        this.mixLevel = mixLevel;
    }

    @Override
    public void init(long worldSeed) {
        if (this.parent != null) {
            this.parent.init(worldSeed);
        }
        super.init(worldSeed);
    }

    @Override
    public int generate(HolderGetter<Biome> biomeRegistry, int x, int z) {
        Biome biome = IntClimateSampleLayer.getBiomeFromLayer(biomeRegistry, this.biomeLayer, x, z);
        if (biome == null) {
            return 32768;
        }
        Biome.ClimateSettings weather = ((BiomeAccessor)biome).getClimateSettings();
        float floatValue = this.downfall ? weather.downfall() : weather.temperature();
        int intValue = (int)(floatValue * 65536.0f);
        if (this.parent == null) {
            return intValue;
        }
        int baseValue = this.parent.sample(biomeRegistry, x, z);
        return baseValue + (intValue - baseValue) / this.mixLevel;
    }
}

