/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome.provider;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.api.level.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.level.biome.BiomeResolverBlock;
import mod.bluestaggo.modernerbeta.api.level.biome.BiomeResolverExtendedIdStepped;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ConfiguredLayers;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;

public class BiomeProviderFractal
extends BiomeProvider
implements BiomeResolverBlock,
BiomeResolverExtendedIdStepped,
BiomeManager.NoiseBiomeSource {
    protected final ConfiguredLayers configuredLayers;
    protected final List<Layer> pipeline;
    private final Supplier<Holder<Biome>> baseBiome = Suppliers.memoize(() -> this.getBiomeEntry(this.settings.getOrDefault(SettingsComponentTypes.SINGLE_BIOME)).orElseThrow());
    private final BiomeManager biomeAccess;
    private final List<Holder<Biome>> allBiomes;
    private final Layer layer;

    public BiomeProviderFractal(ModernBetaSettings settings, HolderGetter<Biome> biomeRegistry, long seed) {
        super(settings, biomeRegistry, seed);
        this.biomeAccess = new BiomeManager((BiomeManager.NoiseBiomeSource)this, seed);
        this.configuredLayers = this.settings.getOrThrow(SettingsComponentTypes.FRACTAL_LAYERS);
        this.pipeline = this.configuredLayers.getPipeline();
        boolean use32BitSeed = this.settings.getOrDefault(SettingsComponentTypes.USE_32BIT_LAYER_SEED);
        if (use32BitSeed) {
            seed &= 0xFFFFFFFFL;
        }
        this.layer = this.configuredLayers.getOutputOrThrow(ModernBetaBuiltInTypes.LayerOutput.BIOME.id);
        this.layer.init(seed);
        HashSet<ExtendedBiomeId> allExtendedBiomes = new HashSet<ExtendedBiomeId>();
        this.layer.addPossibleBiomesRecursive(allExtendedBiomes);
        this.allBiomes = allExtendedBiomes.stream().map(biome -> this.getBiomeEntry(biome.baseId())).filter(Optional::isPresent).map(Optional::get).distinct().toList();
    }

    private Optional<Holder<Biome>> getBiomeEntry(ResourceLocation id) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)id);
        return this.biomeRegistry.get(key);
    }

    @Override
    public Holder<Biome> getBiome(int biomeX, int biomeY, int biomeZ) {
        ResourceLocation baseId = this.getExtendedBiomeId(biomeX, biomeY, biomeZ).baseId();
        return this.getBiomeEntry(baseId).orElseThrow(() -> new NoSuchElementException("Biome \"" + String.valueOf(baseId) + "\" does not exist."));
    }

    @Override
    public ExtendedBiomeId getExtendedBiomeId(int biomeX, int biomeY, int biomeZ) {
        return this.layer.sample(biomeX, biomeZ);
    }

    @Override
    public Holder<Biome> getBiomeBlock(int x, int y, int z) {
        return this.biomeAccess.getBiome(new BlockPos(x, y, z));
    }

    @Override
    public List<Holder<Biome>> getBiomes() {
        return this.allBiomes;
    }

    public Holder<Biome> getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        return this.getBiome(biomeX, biomeY, biomeZ);
    }

    @Override
    public Holder<Biome> getBiomeForStep(int biomeX, int biomeY, int biomeZ, int step) {
        ResourceLocation baseId = this.getExtendedBiomeIdForStep(biomeX, biomeY, biomeZ, step).baseId();
        return this.getBiomeEntry(baseId).orElseThrow(() -> new NoSuchElementException("Biome \"" + String.valueOf(baseId) + "\" does not exist."));
    }

    @Override
    public ExtendedBiomeId getExtendedBiomeIdForStep(int biomeX, int biomeY, int biomeZ, int step) {
        return this.pipeline.get(step).sample(biomeX, biomeZ);
    }

    @Override
    public Component getBiomeName(int biomeX, int biomeY, int biomeZ) {
        return this.getExtendedBiomeName(this.getExtendedBiomeId(biomeX, biomeY, biomeZ));
    }

    @Override
    public Component getBiomeNameForStep(int biomeX, int biomeY, int biomeZ, int step) {
        return this.getExtendedBiomeName(this.getExtendedBiomeIdForStep(biomeX, biomeY, biomeZ, step));
    }

    private Component getExtendedBiomeName(ExtendedBiomeId extendedBiomeId) {
        Component text = (Component)this.getBiomeEntry(extendedBiomeId.baseId()).map(entry -> entry.unwrapKey().map(key -> Component.translatable((String)key.location().toLanguageKey("biome"))).orElse(Component.literal((String)"[unregistered]"))).orElse(Component.literal((String)"[unregistered]"));
        if (!extendedBiomeId.ext().isEmpty()) {
            text = Component.translatable((String)"createWorld.customize.modern_beta.settings.preview.extended_biome_id", (Object[])new Object[]{text, Component.literal((String)extendedBiomeId.ext())});
        }
        return text;
    }

    @Override
    public int getStepCount() {
        return this.pipeline.size();
    }

    @Override
    public Component getStepName(int step) {
        return Component.literal((String)this.pipeline.get(step).toString());
    }
}

