/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.biome;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.level.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.level.biome.BiomeResolverBlock;
import mod.bluestaggo.modernerbeta.api.level.biome.BiomeResolverExtendedId;
import mod.bluestaggo.modernerbeta.api.level.biome.BiomeResolverOcean;
import mod.bluestaggo.modernerbeta.api.level.cavebiome.CaveBiomeProvider;
import mod.bluestaggo.modernerbeta.api.level.provider.BiomeProviderType;
import mod.bluestaggo.modernerbeta.api.level.provider.CaveBiomeProviderType;
import mod.bluestaggo.modernerbeta.level.biome.injector.BiomeInjector;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.registry.IRegistryHandler;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaResourceKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.Heightmap;

public class ModernBetaBiomeSource
extends BiomeSource {
    public static final MapCodec<ModernBetaBiomeSource> CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)RegistryOps.retrieveGetter((ResourceKey)Registries.BIOME), (App)RegistryOps.retrieveGetter(ModernBetaResourceKeys.SETTINGS_PRESET), (App)ModernBetaSettings.WORLD_CODEC.fieldOf("provider_settings").forGetter(biomeSource -> biomeSource.biomeSettings), (App)ModernBetaSettings.WORLD_CODEC.fieldOf("cave_provider_settings").forGetter(biomeSource -> biomeSource.caveBiomeSettings)).apply((Applicative)instance, instance.stable(ModernBetaBiomeSource::new)));
    private final HolderGetter<Biome> biomeRegistry;
    private final HolderGetter<ModernBetaSettingsPreset> presetRegistry;
    private final ModernBetaSettings biomeSettings;
    private final ModernBetaSettings caveBiomeSettings;
    private BiomeProvider biomeProvider;
    private CaveBiomeProvider caveBiomeProvider;
    private ModernBetaChunkGenerator chunkGenerator;

    public ModernBetaBiomeSource(HolderGetter<Biome> biomeRegistry, HolderGetter<ModernBetaSettingsPreset> presetRegistry, ModernBetaSettings biomeSettings, ModernBetaSettings caveBiomeSettings) {
        if (!ModernerBeta.GENERATING_DATA && ModernBetaSettings.DEFAULT_PRESET_ID.equals((Object)biomeSettings.getOrDefault(SettingsComponentTypes.PRESET))) {
            biomeSettings = biomeSettings.extend().remove(SettingsComponentTypes.PRESET).add(SettingsComponentTypes.PRESET, ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_MISCELLANEOUS).defaultSettingsPreset()).build();
        }
        if (!ModernerBeta.GENERATING_DATA && ModernBetaSettings.DEFAULT_PRESET_ID.equals((Object)caveBiomeSettings.getOrDefault(SettingsComponentTypes.PRESET))) {
            caveBiomeSettings = caveBiomeSettings.extend().remove(SettingsComponentTypes.PRESET).add(SettingsComponentTypes.PRESET, ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_MISCELLANEOUS).defaultSettingsPreset()).build();
        }
        this.biomeRegistry = biomeRegistry;
        this.presetRegistry = presetRegistry;
        this.biomeSettings = biomeSettings;
        this.caveBiomeSettings = caveBiomeSettings;
    }

    public void initProvider(long seed) {
        ModernBetaSettings biomeSettings = this.biomeSettings.mapPreset(this.presetRegistry, ModernBetaSettingsPreset::biomeSettings);
        ModernBetaSettings caveBiomeSettings = this.caveBiomeSettings.mapPreset(this.presetRegistry, ModernBetaSettingsPreset::caveBiomeSettings);
        this.biomeProvider = ((BiomeProviderType)ModernBetaRegistries.BIOME.get(biomeSettings.getProvider())).apply(biomeSettings, this.biomeRegistry, seed);
        this.caveBiomeProvider = ((CaveBiomeProviderType)ModernBetaRegistries.CAVE_BIOME.get(caveBiomeSettings.getProvider())).apply(caveBiomeSettings, this.biomeRegistry, seed);
    }

    public Holder<Biome> getNoiseBiome(int biomeX, int biomeY, int biomeZ, Climate.Sampler noiseSampler) {
        return this.biomeProvider.getBiome(biomeX, biomeY, biomeZ);
    }

    public Set<Holder<Biome>> getBiomesWithin(int startX, int startY, int startZ, int radius, Climate.Sampler noiseSampler) {
        if (this.chunkGenerator == null) {
            return super.getBiomesWithin(startX, startY, startZ, radius, noiseSampler);
        }
        int minX = QuartPos.fromBlock((int)(startX - radius));
        int minZ = QuartPos.fromBlock((int)(startZ - radius));
        int maxX = QuartPos.fromBlock((int)(startX + radius));
        int maxZ = QuartPos.fromBlock((int)(startZ + radius));
        int rangeX = maxX - minX + 1;
        int rangeZ = maxZ - minZ + 1;
        HashSet set = Sets.newHashSet();
        for (int localZ = 0; localZ < rangeZ; ++localZ) {
            for (int localX = 0; localX < rangeX; ++localX) {
                int biomeX = minX + localX;
                int biomeZ = minZ + localZ;
                int x = biomeX << 2;
                int z = biomeZ << 2;
                int y = this.chunkGenerator.getHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, null);
                set.add(this.chunkGenerator.getBiomeInjector().getBiomeAtBlock(null, x, y, z, noiseSampler, BiomeInjector.BiomeInjectionStep.ALL));
            }
        }
        return set;
    }

    public Pair<BlockPos, Holder<Biome>> findClosestBiome3d(BlockPos origin, int radius, int horizontalBlockCheckInterval, int verticalBlockCheckInterval, Predicate<Holder<Biome>> predicate, Climate.Sampler noiseSampler, LevelReader level) {
        if (this.chunkGenerator != null) {
            // empty if block
        }
        return super.findClosestBiome3d(origin, radius, horizontalBlockCheckInterval, verticalBlockCheckInterval, predicate, noiseSampler, level);
    }

    public Holder<Biome> getOceanBiome(int biomeX, int biomeY, int biomeZ) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverOcean) {
            BiomeResolverOcean biomeResolverOcean = (BiomeResolverOcean)((Object)biomeProvider);
            return biomeResolverOcean.getOceanBiome(biomeX, biomeY, biomeZ);
        }
        return this.biomeProvider.getBiome(biomeX, biomeY, biomeZ);
    }

    public Holder<Biome> getDeepOceanBiome(int biomeX, int biomeY, int biomeZ) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverOcean) {
            BiomeResolverOcean biomeResolverOcean = (BiomeResolverOcean)((Object)biomeProvider);
            return biomeResolverOcean.getDeepOceanBiome(biomeX, biomeY, biomeZ);
        }
        return this.biomeProvider.getBiome(biomeX, biomeY, biomeZ);
    }

    public Holder<Biome> getCaveBiome(int biomeX, int biomeY, int biomeZ) {
        return this.caveBiomeProvider.getBiome(biomeX, biomeY, biomeZ);
    }

    public Holder<Biome> getBiomeForSpawn(int x, int y, int z) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverBlock) {
            BiomeResolverBlock biomeResolver = (BiomeResolverBlock)((Object)biomeProvider);
            return biomeResolver.getBiomeBlock(x, y, z);
        }
        return this.biomeProvider.getBiome(x >> 2, y >> 2, z >> 2);
    }

    public Holder<Biome> getBiomeForSurfaceGen(WorldGenRegion region, BlockPos pos) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverBlock) {
            BiomeResolverBlock biomeResolver = (BiomeResolverBlock)((Object)biomeProvider);
            return biomeResolver.getBiomeBlock(pos.getX(), pos.getY(), pos.getZ());
        }
        return region.getBiome(pos);
    }

    public ExtendedBiomeId getBiomeForHeightGen(int biomeX, int biomeY, int biomeZ) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverExtendedId) {
            BiomeResolverExtendedId biomeResolver = (BiomeResolverExtendedId)((Object)biomeProvider);
            return biomeResolver.getExtendedBiomeId(biomeX, biomeY, biomeZ);
        }
        return ExtendedBiomeId.of(((ResourceKey)this.biomeProvider.getBiome(biomeX, biomeY, biomeZ).unwrapKey().orElseThrow()).location());
    }

    public void setChunkGenerator(ModernBetaChunkGenerator chunkGenerator) {
        this.chunkGenerator = chunkGenerator;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public CaveBiomeProvider getCaveBiomeProvider() {
        return this.caveBiomeProvider;
    }

    public ModernBetaSettings getBiomeSettings() {
        return this.biomeSettings;
    }

    public ModernBetaSettings getCaveBiomeSettings() {
        return this.caveBiomeSettings;
    }

    public boolean hasOceanBiomes() {
        return this.biomeProvider instanceof BiomeResolverOcean;
    }

    public static void register(IRegistryHandler<?> handler) {
        IRegistryHandler<?> registryHandler = handler;
        registryHandler.register(ModernerBeta.createId("moderner_beta"), CODEC);
    }

    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        ModernBetaSettings biomeSettings = this.biomeSettings.mapPreset(this.presetRegistry, ModernBetaSettingsPreset::biomeSettings);
        ModernBetaSettings caveBiomeSettings = this.caveBiomeSettings.mapPreset(this.presetRegistry, ModernBetaSettingsPreset::caveBiomeSettings);
        Object biomeProvider = ((BiomeProviderType)ModernBetaRegistries.BIOME.get(biomeSettings.getProvider())).apply(biomeSettings, this.biomeRegistry, 0L);
        Object caveBiomeProvider = ((CaveBiomeProviderType)ModernBetaRegistries.CAVE_BIOME.get(caveBiomeSettings.getProvider())).apply(caveBiomeSettings, this.biomeRegistry, 0L);
        ArrayList<Holder<Biome>> biomes = new ArrayList<Holder<Biome>>();
        biomes.addAll(((BiomeProvider)biomeProvider).getBiomes());
        biomes.addAll(((CaveBiomeProvider)caveBiomeProvider).getBiomes());
        return biomes.stream();
    }
}

