/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.forgelike;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.client.ModernerBetaClient;
import mod.bluestaggo.modernerbeta.client.color.BlockColorSampler;
import mod.bluestaggo.modernerbeta.client.color.BlockColors;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.graphical.ModernBetaGraphicalConfigSettingsScreen;
import mod.bluestaggo.modernerbeta.client.registry.ModernBetaClientRegistries;
import mod.bluestaggo.modernerbeta.client.resource.ModernBetaColormapReloadListener;
import mod.bluestaggo.modernerbeta.compat.client.ModCompatClient;
import mod.bluestaggo.modernerbeta.forgelike.FMLUtils;
import mod.bluestaggo.modernerbeta.forgelike.registry.RegistryHelperImpl;
import mod.bluestaggo.modernerbeta.registry.IRegistryHandler;
import mod.bluestaggo.modernerbeta.registry.VanillaRegistryHandler;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="moderner_beta", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEventsClient {
    private static final Consumer<IRegistryHandler<?>> NONE = h -> {};

    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        ModernerBetaClient.init();
        ModCompatClient.initialise(FMLUtils::isModPresent);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, parent) -> new ModernBetaGraphicalConfigSettingsScreen(parent, FMLPaths.CONFIGDIR.get()));
    }

    @SubscribeEvent
    public static void registerToRegistries(RegisterEvent event) {
        Registry registry = event.getRegistry();
        VanillaRegistryHandler registryHandler = new VanillaRegistryHandler(registry);
        ModernerBetaClient.CUSTOM_REGISTRY_HANDLERS.stream().filter(pair -> ((Registry)pair.getA()).key().equals(event.getRegistryKey())).forEach(pair -> ((Consumer)pair.getB()).accept(registryHandler));
    }

    @SubscribeEvent
    public static void registerRegistries(NewRegistryEvent event) {
        RegistryHelperImpl registryHelper = new RegistryHelperImpl(event);
        ModernBetaClientRegistries.makeRegistries(registryHelper);
        ModernerBetaClient.setupCustomRegistryHandlers();
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors.register((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Block)event).register(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void addClientReloadListeners(RegisterClientReloadListenersEvent event) {
        BiConsumer<ResourceLocation, PreparableReloadListener> addListener = (id, resourceReloader) -> event.registerReloadListener(resourceReloader);
        addListener.accept(ModernerBeta.createId("water_colormap"), (PreparableReloadListener)new ModernBetaColormapReloadListener("textures/colormap/water.png", BlockColorSampler.INSTANCE.colormapWater::setColormap));
        addListener.accept(ModernerBeta.createId("underwater_colormap"), (PreparableReloadListener)new ModernBetaColormapReloadListener("textures/colormap/underwater.png", BlockColorSampler.INSTANCE.colormapUnderwater::setColormap));
    }
}

