/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.compat.client.world;

import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import mod.bluestaggo.modernerbeta.compat.client.world.ColorModifierHelper;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class SereneSeasonsCompat
implements ColorModifierHelper {
    private static final TagKey<Biome> TROPICAL_BIOMES = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)VersionCompat.id("sereneseasons", "tropical_biomes"));
    private final Multimap<Object, Object> resolverOverrides;
    private final Object grassResolverType;
    private final Object foliageResolverType;
    private final Method getSeasonStateMethod;
    private final Method getTropicalSeasonMethod;
    private final Method getSubSeasonMethod;
    private final Method applySeasonalGrassColoringMethod;
    private final Method applySeasonalFoliageColoringMethod;
    private final Method applyColorOverrideMethod;

    public SereneSeasonsCompat() {
        try {
            Class<?> seasonColorHandlers = Class.forName("sereneseasons.season.SeasonColorHandlers");
            Class<?> colorOverride = Class.forName("sereneseasons.season.SeasonColorHandlers$ColorOverride");
            Class<?> resolverType = Class.forName("sereneseasons.season.SeasonColorHandlers$ResolverType");
            Class<?> seasonHelper = Class.forName("sereneseasons.api.season.SeasonHelper");
            Class<?> seasonState = Class.forName("sereneseasons.api.season.ISeasonState");
            Class<?> seasonColorProvider = Class.forName("sereneseasons.api.season.ISeasonColorProvider");
            Class<?> seasonColorUtil = Class.forName("sereneseasons.util.SeasonColorUtil");
            Field resolverOverridesField = seasonColorHandlers.getDeclaredField("resolverOverrides");
            resolverOverridesField.setAccessible(true);
            this.resolverOverrides = (Multimap)resolverOverridesField.get(null);
            Field grassResolverTypeField = resolverType.getField("GRASS");
            Field foliageResolverTypeField = resolverType.getField("FOLIAGE");
            this.grassResolverType = grassResolverTypeField.get(null);
            this.foliageResolverType = foliageResolverTypeField.get(null);
            this.getSeasonStateMethod = seasonHelper.getMethod("getSeasonState", Level.class);
            this.getTropicalSeasonMethod = seasonState.getMethod("getTropicalSeason", new Class[0]);
            this.getSubSeasonMethod = seasonState.getMethod("getSubSeason", new Class[0]);
            this.applySeasonalGrassColoringMethod = seasonColorUtil.getMethod("applySeasonalGrassColouring", seasonColorProvider, Holder.class, Integer.TYPE);
            this.applySeasonalFoliageColoringMethod = seasonColorUtil.getMethod("applySeasonalFoliageColouring", seasonColorProvider, Holder.class, Integer.TYPE);
            this.applyColorOverrideMethod = colorOverride.getMethod("apply", Integer.TYPE, Integer.TYPE, Integer.TYPE, Holder.class, Double.TYPE, Double.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialise Serene Seasons compatibility!", e);
        }
    }

    @Override
    public int modifyGrass(int original, Holder<Biome> biome, BlockPos pos) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return original;
        }
        if (biome != null) {
            Object colorProvider = this.getColorProvider((Level)level, biome);
            try {
                int modifiedBaseColor;
                int modifiedColor = modifiedBaseColor = ((Integer)this.applySeasonalGrassColoringMethod.invoke(null, colorProvider, biome, original)).intValue();
                for (Object override : this.resolverOverrides.get(this.grassResolverType)) {
                    modifiedColor = (Integer)this.applyColorOverrideMethod.invoke(override, original, modifiedBaseColor, modifiedColor, biome, pos.getX(), pos.getZ());
                }
                return modifiedColor;
            }
            catch (Exception e) {
                throw new RuntimeException("Reflection into Serene Seasons failed!", e);
            }
        }
        return original;
    }

    @Override
    public int modifyFoliage(int original, Holder<Biome> biome, BlockPos pos) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return original;
        }
        if (biome != null) {
            Object colorProvider = this.getColorProvider((Level)level, biome);
            try {
                int modifiedBaseColor;
                int modifiedColor = modifiedBaseColor = ((Integer)this.applySeasonalFoliageColoringMethod.invoke(null, colorProvider, biome, original)).intValue();
                for (Object override : this.resolverOverrides.get(this.foliageResolverType)) {
                    modifiedColor = (Integer)this.applyColorOverrideMethod.invoke(override, original, modifiedBaseColor, modifiedColor, biome, pos.getX(), pos.getZ());
                }
                return modifiedColor;
            }
            catch (Exception e) {
                throw new RuntimeException("Reflection into Serene Seasons failed!", e);
            }
        }
        return original;
    }

    private Object getColorProvider(Level level, Holder<Biome> biome) {
        try {
            Object seasonState = this.getSeasonStateMethod.invoke(null, level);
            return biome.is(TROPICAL_BIOMES) ? this.getTropicalSeasonMethod.invoke(seasonState, new Object[0]) : this.getSubSeasonMethod.invoke(seasonState, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Reflection into Serene Seasons failed!", e);
        }
    }
}

