/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.compat;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.compat.levelgen.LevelGenCompatHelper;
import mod.bluestaggo.modernerbeta.compat.levelgen.ValkyrienSkiesCompat;

public class ModCompat {
    public static Set<LevelGenCompatHelper> worldGenHelpers = new HashSet<LevelGenCompatHelper>();
    private static boolean compatChecked;

    public static void initialise(Function<String, Boolean> modPresenceFunction) {
        if (compatChecked) {
            throw new IllegalStateException("Tried to initialise mod compatibility workarounds twice!");
        }
        if (modPresenceFunction.apply("valkyrienskies").booleanValue()) {
            worldGenHelpers.add(new ValkyrienSkiesCompat());
        }
        compatChecked = true;
    }

    public static boolean skipGeneratingChunk(int x, int z) {
        if (worldGenHelpers.isEmpty()) {
            return false;
        }
        for (LevelGenCompatHelper helper : worldGenHelpers) {
            if (!helper.skipGeneratingChunk(x, z)) continue;
            return true;
        }
        return false;
    }
}

