/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen.config.json;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.mixin.client.MultiLineEditBoxAccessor;
import mod.bluestaggo.modernerbeta.mixin.client.MultilineTextFieldAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class ModernBetaJSONEditScreen
extends ModernBetaScreen {
    private static final String TEXT_SETTINGS = "createWorld.customize.modern_beta.settings";
    private static final String TEXT_INVALID_JSON = "createWorld.customize.modern_beta.invalid_json";
    protected final Consumer<String> onDone;
    protected final Gson gson;
    protected String settingsString;
    private MultiLineEditBox widgetSettings;
    private StringWidget widgetInvalid;

    public ModernBetaJSONEditScreen(Component title, Screen parent, Consumer<String> onDone) {
        super(title, parent, 40, 33);
        this.onDone = onDone;
        this.gson = this.makeGson();
    }

    @Override
    protected void init() {
        super.init();
        MultilineTextField editBox = ((MultiLineEditBoxAccessor)this.widgetSettings).getTextField();
        editBox.seekCursor(Whence.ABSOLUTE, 0);
        this.onChange(this.isValidJson(this.settingsString));
    }

    @Override
    protected void initContent(GridLayout contentLayout) {
        GridLayout.RowHelper row = contentLayout.createRowHelper(1);
        this.widgetSettings = new MultiLineEditBox(this.font, 0, 0, 100, 100, (Component)Component.literal((String)""), (Component)Component.translatable((String)TEXT_SETTINGS));
        this.widgetSettings.setValue(this.settingsString);
        this.widgetSettings.setValueListener(string -> {
            this.settingsString = string;
            this.onChange(this.isValidJson(this.settingsString));
        });
        MutableComponent textInvalid = Component.translatable((String)TEXT_INVALID_JSON).withStyle(ChatFormatting.RED);
        this.widgetInvalid = new StringWidget((Component)textInvalid, this.font);
        row.addChild((LayoutElement)this.widgetSettings);
        row.addChild((LayoutElement)this.widgetInvalid);
    }

    protected abstract Gson makeGson();

    @Override
    protected void repositionElements() {
        int editBoxWidth = this.width - 16;
        int editBoxHeight = this.layout.getContentHeight() - 16;
        MultilineTextField textField = ((MultiLineEditBoxAccessor)this.widgetSettings).getTextField();
        int textWidth = ((MultilineTextFieldAccessor)textField).getWidth();
        int boxWidth = this.widgetSettings.getWidth();
        int totalPadding = boxWidth - textWidth;
        this.widgetSettings.setSize(editBoxWidth, editBoxHeight);
        ((MultilineTextFieldAccessor)textField).setWidth(editBoxWidth + totalPadding);
        ((MultilineTextFieldAccessor)textField).invokeReflowDisplayLines();
        super.repositionElements();
    }

    protected void onChange(boolean isValid) {
        this.widgetInvalid.visible = !isValid;
    }

    private boolean isValidJson(String json) {
        try {
            JsonParser.parseString((String)json);
        }
        catch (JsonSyntaxException e) {
            return false;
        }
        return true;
    }
}

