/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import java.util.Objects;
import java.util.Random;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaBiomePreviewScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaSettingsPresetScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaDataPackExportScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.graphical.ModernBetaGraphicalProviderSettingsScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.json.ModernBetaImportExportScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.json.ModernBetaSettingsScreen;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaResourceKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPresetCategory;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.tags.ModernBetaSettingsPresetCategoryTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.apache.logging.log4j.util.TriConsumer;

public class ModernBetaWorldScreen
extends ModernBetaScreen {
    private static final String TEXT_TITLE = "createWorld.customize.modern_beta.title";
    private static final String TEXT_TITLE_CHUNK = "createWorld.customize.modern_beta.title.chunk";
    private static final String TEXT_TITLE_BIOME = "createWorld.customize.modern_beta.title.biome";
    private static final String TEXT_TITLE_CAVE_BIOME = "createWorld.customize.modern_beta.title.cave_biome";
    private static final String TEXT_PRESET = "createWorld.customize.modern_beta.preset";
    private static final String TEXT_PRESET_NAME = "createWorld.customize.modern_beta.preset.name";
    private static final String TEXT_PRESET_CUSTOM = "createWorld.customize.modern_beta.preset.custom";
    private static final String TEXT_CHUNK = "createWorld.customize.modern_beta.chunk";
    private static final String TEXT_BIOME = "createWorld.customize.modern_beta.biome";
    private static final String TEXT_CAVE_BIOME = "createWorld.customize.modern_beta.cave_biome";
    private static final String TEXT_SETTINGS = "createWorld.customize.modern_beta.settings";
    private static final String TEXT_SETTINGS_JSON = "createWorld.customize.modern_beta.settings.json";
    private static final String TEXT_SETTINGS_IMPORT_EXPORT = "createWorld.customize.modern_beta.settings.import_export";
    private static final String TEXT_SETTINGS_DATA_PACK_EXPORT = "createWorld.customize.modern_beta.settings.data_pack_export";
    private static final String TEXT_SETTINGS_RESET = "createWorld.customize.modern_beta.settings.reset";
    private static final String TEXT_SETTINGS_RESET_MESSAGE = "createWorld.customize.modern_beta.settings.reset.message";
    private static final String TEXT_SETTINGS_PREVIEW = "createWorld.customize.modern_beta.settings.preview";
    private static final String[] TEXT_HINTS = new String[]{"createWorld.customize.modern_beta.hint.settings"};
    private final TriConsumer<ModernBetaSettings, ModernBetaSettings, ModernBetaSettings> onDone;
    private final String hintString;
    private final WorldCreationContext context;
    private final Registry<ModernBetaSettingsPreset> presetRegistry;
    private final Registry<ModernBetaSettingsPresetCategory> presetCategoryRegistry;
    private ModernBetaSettingsPreset preset;
    private Button buttonPreset;

    public ModernBetaWorldScreen(Screen parent, WorldCreationContext context, TriConsumer<ModernBetaSettings, ModernBetaSettings, ModernBetaSettings> onDone) {
        super((Component)Component.translatable((String)TEXT_TITLE), parent, 33, 40);
        this.layout.setContentMarginTop(0);
        ChunkGenerator chunkGenerator = context.selectedDimensions().overworld();
        ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
        ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)modernBetaChunkGenerator.getBiomeSource();
        this.presetRegistry = context.worldgenLoadContext().registryOrThrow(ModernBetaResourceKeys.SETTINGS_PRESET);
        this.presetCategoryRegistry = context.worldgenLoadContext().registryOrThrow(ModernBetaResourceKeys.SETTINGS_PRESET_CATEGORY);
        this.onDone = onDone;
        this.hintString = TEXT_HINTS[new Random().nextInt(TEXT_HINTS.length)];
        this.preset = new ModernBetaSettingsPreset(modernBetaChunkGenerator.getChunkSettings(), modernBetaBiomeSource.getBiomeSettings(), modernBetaBiomeSource.getCaveBiomeSettings());
        this.context = context;
    }

    public void setPreset(ModernBetaSettingsPreset preset) {
        this.preset = preset;
        this.buttonPreset.setMessage(this.getPresetButtonLabel());
    }

    @Override
    protected void initContent(GridLayout contentLayout) {
        GridLayout gridWidgetSettings = this.createGridWidget();
        GridLayout gridWidgetActions = this.createGridWidget();
        GridLayout.RowHelper mainRows = contentLayout.createRowHelper(1);
        GridLayout.RowHelper settingsRows = gridWidgetSettings.createRowHelper(3);
        GridLayout.RowHelper actionRow = gridWidgetActions.createRowHelper(2);
        settingsRows.defaultCellSetting().alignVerticallyMiddle();
        this.buttonPreset = Button.builder((Component)this.getPresetButtonLabel(), button -> this.minecraft.setScreen(new ModernBetaSettingsPresetScreen(this, this.presetCategoryRegistry.getOrCreateTag(ModernBetaSettingsPresetCategoryTags.SELECTABLE).stream().toList(), (screen, name, preset) -> this.minecraft.setScreen(new ModernBetaSettingsPresetScreen((ModernBetaScreen)((Object)((Object)screen)), this.presetRegistry.getOrCreateTag(preset.presetTag()).stream().toList(), (parentScreen, presetName, settingsPreset) -> {
            Screen patt0$temp;
            this.setPreset(ModernBetaSettingsPreset.referenced(presetName));
            while ((patt0$temp = this.minecraft.screen) instanceof ModernBetaSettingsPresetScreen) {
                ModernBetaSettingsPresetScreen subPresetScreen = (ModernBetaSettingsPresetScreen)patt0$temp;
                this.minecraft.setScreen(subPresetScreen.parent);
            }
        }, true)), false))).size(200, 20).build();
        HolderLookup.RegistryLookup presetLookup = this.presetRegistry.asLookup();
        Button buttonChunk = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS), arg_0 -> this.lambda$initContent$4((HolderGetter)presetLookup, arg_0)).build();
        Button buttonChunkAdvanced = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_JSON), arg_0 -> this.lambda$initContent$6((HolderGetter)presetLookup, arg_0)).size(20, 20).build();
        Button buttonBiome = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS), arg_0 -> this.lambda$initContent$8((HolderGetter)presetLookup, arg_0)).build();
        Button buttonBiomeAdvanced = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_JSON), arg_0 -> this.lambda$initContent$10((HolderGetter)presetLookup, arg_0)).size(20, 20).build();
        Button buttonCaveBiome = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS), arg_0 -> this.lambda$initContent$12((HolderGetter)presetLookup, arg_0)).build();
        Button buttonCaveBiomeAdvanced = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_JSON), arg_0 -> this.lambda$initContent$14((HolderGetter)presetLookup, arg_0)).size(20, 20).build();
        Button buttonReset = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_RESET), button -> this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                this.resetPreset();
            }
            this.minecraft.setScreen((Screen)this);
        }, (Component)Component.empty(), (Component)Component.translatable((String)TEXT_SETTINGS_RESET_MESSAGE), (Component)Component.translatable((String)TEXT_SETTINGS_RESET), CommonComponents.GUI_CANCEL))).build();
        Button buttonPreview = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_PREVIEW), arg_0 -> this.lambda$initContent$17((HolderGetter)presetLookup, arg_0)).build();
        Button importExportButton = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_IMPORT_EXPORT), button -> this.minecraft.setScreen((Screen)new ModernBetaImportExportScreen(TEXT_SETTINGS_IMPORT_EXPORT, this, this.preset, (HolderLookup.Provider)this.context.worldgenLoadContext(), str -> {
            Tuple<ModernBetaSettingsPreset, Boolean> read = ModernBetaSettingsPreset.fromJson((HolderLookup.Provider)this.context.worldgenLoadContext(), str);
            if (((Boolean)read.getB()).booleanValue()) {
                this.setPreset((ModernBetaSettingsPreset)read.getA());
            }
        }))).build();
        Button dataPackExportButton = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_DATA_PACK_EXPORT), button -> this.minecraft.setScreen((Screen)new ModernBetaDataPackExportScreen(TEXT_SETTINGS_DATA_PACK_EXPORT, (Screen)this, this.preset, (RegistryAccess)this.context.worldgenLoadContext()))).pos(0, 20).build();
        mainRows.addChild((LayoutElement)this.buttonPreset);
        mainRows.addChild((LayoutElement)gridWidgetSettings);
        mainRows.addChild((LayoutElement)gridWidgetActions);
        this.addGridTextButtonTriplet(settingsRows, TEXT_CHUNK, buttonChunk, buttonChunkAdvanced);
        this.addGridTextButtonTriplet(settingsRows, TEXT_BIOME, buttonBiome, buttonBiomeAdvanced);
        this.addGridTextButtonTriplet(settingsRows, TEXT_CAVE_BIOME, buttonCaveBiome, buttonCaveBiomeAdvanced);
        actionRow.addChild((LayoutElement)buttonReset);
        actionRow.addChild((LayoutElement)buttonPreview);
        actionRow.addChild((LayoutElement)importExportButton);
        actionRow.addChild((LayoutElement)dataPackExportButton);
    }

    @Override
    protected void initFooter(GridLayout footerLayout) {
        GridLayout gridWidgetActions = this.createGridWidget();
        GridLayout.RowHelper mainRow = footerLayout.createRowHelper(1);
        GridLayout.RowHelper actionRow = gridWidgetActions.createRowHelper(2);
        MutableComponent hintText = Component.translatable((String)this.hintString).withStyle(ChatFormatting.GRAY);
        int hintTextWidth = this.font.width(hintText.getVisualOrderText());
        Objects.requireNonNull(this.font);
        int hintTextHeight = 9;
        mainRow.addChild((LayoutElement)new StringWidget(hintTextWidth, hintTextHeight, (Component)hintText, this.font));
        mainRow.addChild((LayoutElement)gridWidgetActions);
        Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.onDone.accept((Object)this.preset.chunkSettings(), (Object)this.preset.biomeSettings(), (Object)this.preset.caveBiomeSettings());
            this.minecraft.setScreen(this.parent);
        }).size(150, 20).build();
        Button cancelButton = Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(this.parent)).size(150, 20).build();
        actionRow.addChild((LayoutElement)doneButton);
        actionRow.addChild((LayoutElement)cancelButton);
    }

    private void resetPreset() {
        this.setPreset(ModernBetaSettingsPreset.referenced(ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_MISCELLANEOUS).defaultSettingsPreset()));
    }

    private ResourceLocation getPresetKey() {
        ResourceLocation presetKey = null;
        for (ModernBetaSettings settings : this.preset.asList()) {
            ResourceLocation subPresetKey = settings.get(SettingsComponentTypes.PRESET);
            if (ModernBetaSettings.DEFAULT_PRESET_ID.equals((Object)subPresetKey)) {
                subPresetKey = ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_MISCELLANEOUS).defaultSettingsPreset();
            }
            if (subPresetKey == null || presetKey != null && !presetKey.equals((Object)subPresetKey)) {
                return null;
            }
            presetKey = subPresetKey;
        }
        return presetKey;
    }

    private Component getPresetButtonLabel() {
        MutableComponent presetText = Component.translatable((String)TEXT_PRESET).append(": ");
        ResourceLocation presetKey = this.getPresetKey();
        presetText.append((Component)(presetKey == null ? Component.translatable((String)TEXT_PRESET_CUSTOM).withStyle(ChatFormatting.AQUA) : Component.translatable((String)("createWorld.customize.modern_beta.preset.name." + presetKey.toLanguageKey())).withStyle(ChatFormatting.YELLOW)));
        return presetText;
    }

    private /* synthetic */ void lambda$initContent$17(HolderGetter presetLookup, Button button) {
        this.minecraft.setScreen((Screen)new ModernBetaBiomePreviewScreen((Component)Component.translatable((String)TEXT_SETTINGS_PREVIEW), (Screen)this, this.context, this.preset.biomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::biomeSettings)));
    }

    private /* synthetic */ void lambda$initContent$14(HolderGetter presetLookup, Button button) {
        this.minecraft.setScreen((Screen)new ModernBetaSettingsScreen(TEXT_TITLE_CAVE_BIOME, this, this.preset.caveBiomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::caveBiomeSettings), (HolderLookup.Provider)this.context.worldgenLoadContext(), string -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setJson((HolderLookup.Provider)this.context.worldgenLoadContext(), "", "", (String)string);
            this.setPreset((ModernBetaSettingsPreset)updatedPreset.getA());
        }));
    }

    private /* synthetic */ void lambda$initContent$12(HolderGetter presetLookup, Button button) {
        ModernBetaSettings settings = this.preset.caveBiomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::caveBiomeSettings);
        this.minecraft.setScreen((Screen)new ModernBetaGraphicalProviderSettingsScreen(TEXT_TITLE_CHUNK, this, this.context, settings.toCompound(), settings, nbtCompound -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setNbt((HolderLookup.Provider)this.context.worldgenLoadContext(), null, null, (CompoundTag)nbtCompound);
            this.setPreset((ModernBetaSettingsPreset)updatedPreset.getA());
        }, ModernBetaRegistries.CAVE_BIOME));
    }

    private /* synthetic */ void lambda$initContent$10(HolderGetter presetLookup, Button button) {
        this.minecraft.setScreen((Screen)new ModernBetaSettingsScreen(TEXT_TITLE_BIOME, this, this.preset.biomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::biomeSettings), (HolderLookup.Provider)this.context.worldgenLoadContext(), string -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setJson((HolderLookup.Provider)this.context.worldgenLoadContext(), "", (String)string, "");
            this.setPreset((ModernBetaSettingsPreset)updatedPreset.getA());
        }));
    }

    private /* synthetic */ void lambda$initContent$8(HolderGetter presetLookup, Button button) {
        ModernBetaSettings settings = this.preset.biomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::biomeSettings);
        this.minecraft.setScreen((Screen)new ModernBetaGraphicalProviderSettingsScreen(TEXT_TITLE_CHUNK, this, this.context, settings.toCompound(), settings, nbtCompound -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setNbt((HolderLookup.Provider)this.context.worldgenLoadContext(), null, (CompoundTag)nbtCompound, null);
            this.setPreset((ModernBetaSettingsPreset)updatedPreset.getA());
        }, ModernBetaRegistries.BIOME));
    }

    private /* synthetic */ void lambda$initContent$6(HolderGetter presetLookup, Button button) {
        this.minecraft.setScreen((Screen)new ModernBetaSettingsScreen(TEXT_TITLE_CHUNK, this, this.preset.chunkSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::chunkSettings), (HolderLookup.Provider)this.context.worldgenLoadContext(), string -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setJson((HolderLookup.Provider)this.context.worldgenLoadContext(), (String)string, "", "");
            this.setPreset((ModernBetaSettingsPreset)updatedPreset.getA());
        }));
    }

    private /* synthetic */ void lambda$initContent$4(HolderGetter presetLookup, Button button) {
        ModernBetaSettings settings = this.preset.chunkSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::chunkSettings);
        this.minecraft.setScreen((Screen)new ModernBetaGraphicalProviderSettingsScreen(TEXT_TITLE_CHUNK, this, this.context, settings.toCompound(), settings, nbtCompound -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setNbt((HolderLookup.Provider)this.context.worldgenLoadContext(), (CompoundTag)nbtCompound, null, null);
            this.setPreset((ModernBetaSettingsPreset)updatedPreset.getA());
        }, ModernBetaRegistries.CHUNK));
    }
}

