/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import java.util.List;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaSettingsPresetScreen;
import mod.bluestaggo.modernerbeta.settings.NameAndDescriptionItem;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class ModernBetaSettingsPresetScreen<T extends NameAndDescriptionItem>
extends ModernBetaScreen {
    private static final String TEXT_TITLE = "createWorld.customize.modern_beta.title.preset";
    private final List<Holder<T>> presets;
    private final boolean enableSelect;
    private final TriConsumer<ModernBetaSettingsPresetScreen<?>, ResourceLocation, T> onSelected;
    private PresetsListWidget listWidget;
    private Button selectPresetButton;

    public ModernBetaSettingsPresetScreen(ModernBetaScreen parent, List<Holder<T>> presets, TriConsumer<ModernBetaSettingsPresetScreen<?>, ResourceLocation, T> onSelected, boolean enableSelect) {
        super((Component)Component.translatable((String)TEXT_TITLE), parent);
        this.presets = presets;
        this.enableSelect = enableSelect;
        this.onSelected = onSelected;
    }

    @Override
    protected void init() {
        super.init();
        this.updateSelectButton(this.listWidget.getSelected() instanceof PresetsListWidget.PresetEntry);
    }

    @Override
    protected void initContent(GridLayout contentLayout) {
        this.listWidget = new PresetsListWidget(this.presets);
        this.layout.addToContents(this.listWidget);
    }

    @Override
    protected void initFooter(GridLayout footerLayout) {
        GridLayout.RowHelper row = footerLayout.createRowHelper(2);
        this.selectPresetButton = Button.builder((Component)Component.translatable((String)"createWorld.customize.presets.select"), onPress -> {
            PresetsListWidget.PresetEntry entry = (PresetsListWidget.PresetEntry)this.listWidget.getSelected();
            if (entry != null) {
                this.onSelected.accept((Object)this, (Object)entry.presetName, entry.preset);
            }
        }).size(150, 20).build();
        Button cancelButton = Button.builder((Component)(!this.enableSelect ? CommonComponents.GUI_CANCEL : CommonComponents.GUI_BACK), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
            }
        }).size(150, 20).build();
        this.selectPresetButton.active = this.enableSelect;
        row.addChild((LayoutElement)this.selectPresetButton);
        row.addChild((LayoutElement)cancelButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.listWidget.render(graphics, mouseX, mouseY, delta);
    }

    @Override
    protected void repositionElements() {
        super.repositionElements();
        this.listWidget.setSize(this.width, this.layout.getContentHeight());
        this.listWidget.setPosition(0, this.layout.getHeaderHeight());
        this.listWidget.setScrollAmount(this.listWidget.getScrollAmount());
    }

    private void updateSelectButton(boolean hasSelected) {
        this.selectPresetButton.active = hasSelected;
    }

    private class PresetsListWidget
    extends ObjectSelectionList<mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaSettingsPresetScreen$PresetsListWidget.PresetEntry> {
        private static final int ITEM_HEIGHT = 60;
        private static final int ICON_SIZE = 56;
        private static final int SCROLLBAR_X_OFFSET = 30;

        public PresetsListWidget(List<Holder<T>> presets) {
            super(ModernBetaSettingsPresetScreen.this.minecraft, ModernBetaSettingsPresetScreen.this.width, ModernBetaSettingsPresetScreen.this.layout.getContentHeight(), ModernBetaSettingsPresetScreen.this.layout.getHeaderHeight(), 60);
            presets.forEach(holder -> this.addEntry((AbstractSelectionList.Entry)new PresetEntry(this, ((ResourceKey)holder.unwrapKey().orElseThrow()).location(), (NameAndDescriptionItem)holder.value())));
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(PresetEntry entry) {
            super.setSelected((AbstractSelectionList.Entry)entry);
            ModernBetaSettingsPresetScreen.this.updateSelectButton(entry != null && ModernBetaSettingsPresetScreen.this.enableSelect);
        }

        protected int getScrollbarPosition() {
            return super.getScrollbarPosition() + 30;
        }

        public int getRowWidth() {
            return super.getRowWidth() + 85;
        }

        private static class PresetEntry
        extends ObjectSelectionList.Entry<mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaSettingsPresetScreen$PresetsListWidget.PresetEntry> {
            private static final ResourceLocation TEXTURE_JOIN = VersionCompat.vanillaId("world_list/join");
            private static final ResourceLocation TEXTURE_JOIN_HIGHLIGHTED = VersionCompat.vanillaId("world_list/join_highlighted");
            private static final int TEXT_SPACING = 11;
            private static final int TEXT_LENGTH = 240;
            private final ResourceLocation presetTexture;
            private final Component presetTitle;
            private final Component presetDesc;
            protected final T preset;
            protected final ResourceLocation presetName;
            private long time;
            final /* synthetic */ PresetsListWidget this$1;

            public PresetEntry(ResourceLocation presetName, T preset) {
                this.this$1 = var1_1;
                this.preset = preset;
                this.presetName = presetName;
                this.presetTexture = preset.getTextureLocation(presetName);
                this.presetTitle = preset.makeOrGetTitleComponent(presetName);
                this.presetDesc = preset.makeOrGetDescriptionComponent(presetName);
            }

            @NotNull
            public Component getNarration() {
                return Component.empty();
            }

            public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                List<FormattedCharSequence> presetDescTexts = this.splitText(this.this$1.ModernBetaSettingsPresetScreen.this.font, this.presetDesc);
                int textStartX = x + 56 + 3;
                int textStartY = 1;
                graphics.drawString(this.this$1.ModernBetaSettingsPresetScreen.this.font, this.presetTitle, textStartX, y + textStartY, -1, false);
                int descSpacing = 11 + textStartY + 1;
                for (FormattedCharSequence line : presetDescTexts) {
                    graphics.drawString(this.this$1.ModernBetaSettingsPresetScreen.this.font, line, textStartX, y + descSpacing, -8355712, false);
                    descSpacing += 11;
                }
                this.draw(graphics, x, y, this.presetTexture);
                if (((Boolean)((PresetsListWidget)this.this$1).minecraft.options.touchscreen().get()).booleanValue() || hovered) {
                    boolean isMouseHovering = mouseX - x < 56;
                    graphics.fill(x, y, x + 56, y + 56, -1601138544);
                    ResourceLocation texture = isMouseHovering ? TEXTURE_JOIN_HIGHLIGHTED : TEXTURE_JOIN;
                    graphics.blitSprite(texture, x, y, 56, 56);
                }
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (button != 0) {
                    return false;
                }
                this.this$1.setSelected(this);
                if (mouseX - (double)this.this$1.getRowLeft() <= 56.0 || Util.getMillis() - this.time < 250L) {
                    this.this$1.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    this.this$1.ModernBetaSettingsPresetScreen.this.onSelected.accept((Object)this.this$1.ModernBetaSettingsPresetScreen.this, (Object)this.presetName, this.preset);
                }
                this.time = Util.getMillis();
                return true;
            }

            private void draw(GuiGraphics graphics, int x, int y, ResourceLocation textureId) {
                graphics.blit(textureId, x, y, 0.0f, 0.0f, 56, 56, 56, 56);
            }

            private List<FormattedCharSequence> splitText(Font textRenderer, Component text) {
                return textRenderer.split((FormattedText)text, 240);
            }
        }
    }
}

