/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.optioncallbacks;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public record TextFieldCallbacks(Predicate<String> validationFunction, Predicate<String> inputValidationFunction) implements OptionInstance.ValueSet<String>
{
    public static final TextFieldCallbacks NO_VALIDATION = new TextFieldCallbacks(Objects::nonNull, Objects::nonNull);

    public TextFieldCallbacks(Predicate<String> validationFunction) {
        this(validationFunction, Objects::nonNull);
    }

    @NotNull
    public Function<OptionInstance<String>, AbstractWidget> createButton(OptionInstance.TooltipSupplier<String> tooltipFactory, Options gameOptions, int x, int y, int width, Consumer<String> changeCallback) {
        return option -> {
            EditBox widget = new EditBox(Minecraft.getInstance().fontFilterFishy, x, y, width, 20, Component.nullToEmpty((String)option.toString()));
            widget.setMaxLength(256);
            widget.setResponder(arg_0 -> ((OptionInstance)option).set(arg_0));
            widget.setFilter(this.inputValidationFunction);
            widget.setValue((String)option.get());
            return widget;
        };
    }

    @NotNull
    public Optional<String> validateValue(String value) {
        return this.validationFunction.test(value) ? Optional.of(value) : Optional.empty();
    }

    @NotNull
    public Codec<String> codec() {
        return Codec.STRING;
    }
}

