/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.debug.entries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;

public class DebugEntryHeightmap {
    public static Collection<String> getLines(Level level, int x, int z) {
        if (!(level instanceof ServerLevel)) {
            return List.of();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ChunkGenerator chunkGenerator = serverLevel.getChunkSource().getGenerator();
        ArrayList<String> lines = new ArrayList<String>();
        if (chunkGenerator instanceof ModernBetaChunkGenerator) {
            ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
            ChunkProvider chunkProvider = modernBetaChunkGenerator.getChunkProvider();
            lines.add(String.format("[Modern Beta] Chunk Provider WS height: %d OF height: %d Sea level: %d", chunkProvider.getHeight((LevelHeightAccessor)level, x, z, Heightmap.Types.WORLD_SURFACE_WG), chunkProvider.getHeight((LevelHeightAccessor)level, x, z, Heightmap.Types.OCEAN_FLOOR), chunkProvider.getSeaLevel()));
            if (chunkProvider instanceof ChunkProviderNoise) {
                ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
                lines.add(String.format("[Modern Beta] Noise Chunk Provider WSF height: %d", noiseChunkProvider.getHeight((LevelHeightAccessor)level, x, z, ChunkHeightmap.Type.SURFACE_FLOOR)));
            }
        }
        return lines;
    }
}

