/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.level.chunk.surface;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mod.bluestaggo.modernerbeta.api.level.chunk.surface.SurfaceBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public record SurfaceConfig(SurfaceBlocks normal, SurfaceBlocks beachSand, SurfaceBlocks beachGravel, TagKey<Biome> biomeTag) {
    public static final Codec<SurfaceConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SurfaceBlocks.CODEC.fieldOf("normal").forGetter(SurfaceConfig::normal), (App)SurfaceBlocks.CODEC.fieldOf("beachSand").forGetter(SurfaceConfig::beachSand), (App)SurfaceBlocks.CODEC.fieldOf("beachGravel").forGetter(SurfaceConfig::beachGravel), (App)TagKey.codec((ResourceKey)Registries.BIOME).fieldOf("biomeTag").forGetter(SurfaceConfig::biomeTag)).apply((Applicative)instance, SurfaceConfig::new));
    public static final SurfaceConfig DEFAULT = new SurfaceConfig(SurfaceBlocks.GRASS, SurfaceBlocks.SAND, SurfaceBlocks.GRAVEL, null);

    public SurfaceConfig(SurfaceBlocks surfaceBlocks, TagKey<Biome> biomeTag) {
        this(surfaceBlocks, surfaceBlocks, surfaceBlocks, biomeTag);
    }

    public static SurfaceConfig getSurfaceConfig(Holder<Biome> biome, HolderLookup<SurfaceConfig> surfaceConfigLookup) {
        if (surfaceConfigLookup == null) {
            return DEFAULT;
        }
        Optional<Holder.Reference> optionalKey = surfaceConfigLookup.listElements().filter(entry -> entry.isBound() && ((SurfaceConfig)entry.value()).biomeTag != null && biome.is(((SurfaceConfig)entry.value()).biomeTag)).findFirst();
        return optionalKey.map(Holder.Reference::value).orElse(DEFAULT);
    }
}

