/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.level.chunk.noise;

import mod.bluestaggo.modernerbeta.api.level.chunk.noise.NoiseProvider;
import mod.bluestaggo.modernerbeta.api.level.chunk.noise.NoiseSampler;

public class NoiseProviderBase
extends NoiseProvider {
    private final BaseColumnSampler bufferSampler;
    protected double[] heightmapNoise;

    public NoiseProviderBase(int noiseSizeX, int noiseSizeY, int noiseSizeZ, BaseColumnSampler bufferSampler) {
        super(noiseSizeX, noiseSizeY, noiseSizeZ);
        this.bufferSampler = bufferSampler;
    }

    public NoiseSampler getSamplerForHeightmap() {
        return new NoiseSampler(this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ, this.heightmapNoise);
    }

    @Override
    protected double[] sampleNoise(int startNoiseX, int startNoiseZ) {
        double[] primaryBuffer = new double[this.noiseResY];
        double[] heightmapBuffer = new double[this.noiseResY];
        double[] noise = new double[this.noiseSize];
        double[] heightmapNoise = new double[this.noiseSize];
        int ndx = 0;
        for (int localNoiseX = 0; localNoiseX < this.noiseResX; ++localNoiseX) {
            for (int localNoiseZ = 0; localNoiseZ < this.noiseResZ; ++localNoiseZ) {
                this.bufferSampler.sampleColumn(primaryBuffer, heightmapBuffer, startNoiseX, startNoiseZ, localNoiseX, localNoiseZ);
                System.arraycopy(primaryBuffer, 0, noise, ndx, this.noiseResY);
                System.arraycopy(heightmapBuffer, 0, heightmapNoise, ndx, this.noiseResY);
                ndx += this.noiseResY;
            }
        }
        this.heightmapNoise = heightmapNoise;
        return noise;
    }

    @FunctionalInterface
    public static interface BaseColumnSampler {
        public void sampleColumn(double[] var1, double[] var2, int var3, int var4, int var5, int var6);
    }
}

