/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.level.biome.climate;

import mod.bluestaggo.modernerbeta.api.debug.DebugTextProvider2D;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.TemperatureHeightScaling;
import mod.bluestaggo.modernerbeta.settings.component.ClimateDistribution;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.biome.Biome;

public interface ClimateSampler
extends DebugTextProvider2D {
    public Clime sample(int var1, int var2);

    default public double sampleModifiedTemperature(BlockPos blockPos, Biome.TemperatureModifier modifier) {
        double temp = this.sample(blockPos.getX(), blockPos.getZ()).temp();
        if (this.getHeightType().supportsModifier(modifier)) {
            temp = modifier.modifyTemperature(blockPos, (float)temp);
        }
        return temp;
    }

    default public boolean useBiomeColor() {
        return false;
    }

    default public boolean useWaterColor() {
        return false;
    }

    default public boolean useBiomeFeature() {
        return true;
    }

    default public ClimateDistribution getDistribution() {
        return ClimateDistribution.DEFAULT;
    }

    default public double getSnowThreshold() {
        return 0.5;
    }

    default public TemperatureHeightScaling getHeightType() {
        return TemperatureHeightScaling.NONE;
    }
}

