/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.sort_it_out.command;

import com.mojang.brigadier.context.CommandContext;
import dev.architectury.networking.NetworkManager;
import io.github.jamalam360.sort_it_out.command.ServerTranslationsHelper;
import io.github.jamalam360.sort_it_out.network.BidirectionalUserPreferencesUpdatePacket;
import io.github.jamalam360.sort_it_out.preference.ServerUserPreferences;
import io.github.jamalam360.sort_it_out.preference.UserPreferences;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandFeedback {
    public static Component formatInvertSorting(CommandContext<CommandSourceStack> ctx) {
        return CommandFeedback.translatable(ctx, "text.sort_it_out.command.invert_sorting", CommandFeedback.getPlayerPrefs(ctx).invertSorting ? Component.literal((String)"Yes") : Component.literal((String)"No"));
    }

    public static Component formatComparators(CommandContext<CommandSourceStack> ctx) {
        return CommandFeedback.translatable(ctx, "text.sort_it_out.command.comparators", CommandFeedback.formatComparatorList(ctx, CommandFeedback.getPlayerPrefs(ctx).comparators));
    }

    public static Component formatComparatorList(CommandContext<CommandSourceStack> ctx, List<UserPreferences.SortingComparator> comparators) {
        MutableComponent result = CommandFeedback.formatSingleComparator(ctx, comparators.getFirst());
        for (int i = 1; i < comparators.size(); ++i) {
            result = result.append(", ").append((Component)CommandFeedback.formatSingleComparator(ctx, comparators.get(i)));
        }
        return result;
    }

    private static MutableComponent formatSingleComparator(CommandContext<CommandSourceStack> ctx, UserPreferences.SortingComparator comparator) {
        return CommandFeedback.translatable(ctx, "config.sort_it_out.client_preferences.comparators." + comparator.name().toLowerCase(), new Object[0]);
    }

    public static Component formatSlotSortingTrigger(CommandContext<CommandSourceStack> ctx) {
        return CommandFeedback.translatable(ctx, "text.sort_it_out.command.slot_sorting_trigger", CommandFeedback.formatSingleSlotSortingTrigger(ctx, CommandFeedback.getPlayerPrefs(ctx).slotSortingTrigger));
    }

    private static MutableComponent formatSingleSlotSortingTrigger(CommandContext<CommandSourceStack> ctx, UserPreferences.SlotSortingTrigger comparator) {
        return CommandFeedback.translatable(ctx, "config.sort_it_out.client_preferences.slotSortingTrigger." + comparator.name().toLowerCase(), new Object[0]);
    }

    public static MutableComponent translatable(CommandContext<CommandSourceStack> ctx, String key, Object ... args) {
        if (NetworkManager.canPlayerReceive((ServerPlayer)((CommandSourceStack)ctx.getSource()).getPlayer(), BidirectionalUserPreferencesUpdatePacket.S2C.TYPE)) {
            return Component.translatable((String)key, (Object[])args);
        }
        String lang = ((CommandSourceStack)ctx.getSource()).getPlayer() == null ? "en_us" : ((CommandSourceStack)ctx.getSource()).getPlayer().clientInformation().language();
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof Component)) continue;
            Component component = (Component)object;
            args[i] = component.getString();
        }
        return Component.literal((String)String.format(ServerTranslationsHelper.getTranslation(lang, key), args));
    }

    public static UserPreferences getPlayerPrefs(CommandContext<CommandSourceStack> ctx) {
        return ServerUserPreferences.INSTANCE.getPlayerPreferences((Player)((CommandSourceStack)ctx.getSource()).getPlayer());
    }
}

