/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.sort_it_out.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.jamlib.events.client.ClientPlayLifecycleEvents;
import io.github.jamalam360.sort_it_out.SortItOut;
import io.github.jamalam360.sort_it_out.client.ClientPacketWorkQueue;
import io.github.jamalam360.sort_it_out.client.ClientSortableContainer;
import io.github.jamalam360.sort_it_out.client.Config;
import io.github.jamalam360.sort_it_out.client.button.ScreenSortButtonsLoader;
import io.github.jamalam360.sort_it_out.client.mixin.AbstractContainerScreenAccessor;
import io.github.jamalam360.sort_it_out.network.BidirectionalUserPreferencesUpdatePacket;
import io.github.jamalam360.sort_it_out.network.C2SRequestSortPacket;
import io.github.jamalam360.sort_it_out.preference.ServerUserPreferences;
import io.github.jamalam360.sort_it_out.preference.UserPreferences;
import io.github.jamalam360.sort_it_out.sort.ContainerSorterUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class SortItOutClient {
    public static final ConfigManager<Config> CONFIG = new ConfigManager("sort_it_out", "client_preferences", Config.class);
    private static KeyMapping sortKeyMapping;
    private static boolean isClientSortingForced;
    private static boolean isSlotIndexOverlayEnabled;

    public static void init() {
        ServerUserPreferences.INSTANCE.setClientUserPreferences(CONFIG);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)ScreenSortButtonsLoader.INSTANCE, (ResourceLocation)SortItOut.id("sort_button_reloader"));
        sortKeyMapping = new KeyMapping("key.sort_it_out.sort", 73, "category.sort_it_out");
        KeyMappingRegistry.register((KeyMapping)sortKeyMapping);
        ClientTickEvent.CLIENT_LEVEL_POST.register(SortItOutClient::postLevelTick);
        ClientPlayLifecycleEvents.JOIN.register(mc -> ((Config)CONFIG.get()).sync());
        ClientScreenInputEvent.KEY_RELEASED_PRE.register(SortItOutClient::keyReleased);
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register(SortItOutClient::mouseReleased);
        ClientGuiEvent.RENDER_CONTAINER_FOREGROUND.register(SortItOutClient::renderContainerForeground);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, BidirectionalUserPreferencesUpdatePacket.S2C.TYPE, BidirectionalUserPreferencesUpdatePacket.S2C.STREAM_CODEC, (prefs, ctx) -> {
            ((Config)SortItOutClient.CONFIG.get()).invertSorting = prefs.preferences().invertSorting;
            ((Config)SortItOutClient.CONFIG.get()).comparators = prefs.preferences().comparators;
            CONFIG.save();
            SortItOut.LOGGER.info("Received updated preferences from server (via config-edit commands)");
        });
        ClientCommandRegistrationEvent.EVENT.register((dispatcher, context) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"sortitoutc").then(ClientCommandRegistrationEvent.literal((String)"toggle_force_client_sort").executes(ctx -> {
            isClientSortingForced = !isClientSortingForced;
            ((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource()).arch$sendSuccess(() -> Component.literal((String)("Client Sorting Forced: " + isClientSortingForced)), false);
            return 0;
        }))).then(ClientCommandRegistrationEvent.literal((String)"toggle_slot_index_debug_renderer").executes(ctx -> {
            isSlotIndexOverlayEnabled = !isSlotIndexOverlayEnabled;
            ((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource()).arch$sendSuccess(() -> Component.literal((String)("Slot Index Debug Overlay: " + isSlotIndexOverlayEnabled)), false);
            return 0;
        }))));
    }

    public static void sortOnEitherSide(AbstractContainerMenu menu, Slot slot) {
        if (NetworkManager.canServerReceive(C2SRequestSortPacket.TYPE) && !isClientSortingForced) {
            NetworkManager.sendToServer((CustomPacketPayload)new C2SRequestSortPacket(menu.containerId, slot.index));
        } else if (!ClientPacketWorkQueue.INSTANCE.hasWorkRemaining()) {
            ContainerSorterUtil.sortWithSelectionSort(slot.container, new ClientSortableContainer(slot.container), (UserPreferences)CONFIG.get());
        } else {
            return;
        }
        SortItOut.playSortSound((Player)Minecraft.getInstance().player);
    }

    private static void postLevelTick(ClientLevel level) {
        ClientPacketWorkQueue.INSTANCE.tick();
        while (sortKeyMapping.consumeClick()) {
            Screen screen = Minecraft.getInstance().screen;
            if (!(screen instanceof AbstractContainerScreen)) continue;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            int mouseX = (int)(Minecraft.getInstance().mouseHandler.xpos() * (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() / (double)Minecraft.getInstance().getWindow().getScreenWidth());
            int mouseY = (int)(Minecraft.getInstance().mouseHandler.ypos() * (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / (double)Minecraft.getInstance().getWindow().getScreenHeight());
            Slot hovered = null;
            for (Slot slot : containerScreen.getMenu().slots) {
                if (!((AbstractContainerScreenAccessor)containerScreen).invokeIsHovering(slot, mouseX, mouseY)) continue;
                hovered = slot;
                break;
            }
            if (hovered == null) {
                return;
            }
            SortItOutClient.sortOnEitherSide(Minecraft.getInstance().player.containerMenu, hovered);
        }
    }

    private static void renderContainerForeground(AbstractContainerScreen<?> screen, GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (ClientPacketWorkQueue.INSTANCE.hasWorkRemaining()) {
            Font font = Minecraft.getInstance().font;
            MutableComponent component = Component.translatable((String)"text.sort_it_out.sort_in_progress");
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, (float)(-((AbstractContainerScreenAccessor)screen).getTopPos()), 0.0f);
            graphics.drawCenteredString(font, (Component)component, ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2, 6, 0xFFFFFF);
            graphics.pose().popPose();
        }
        if (isSlotIndexOverlayEnabled) {
            ResourceLocation type;
            try {
                type = BuiltInRegistries.MENU.getKey((Object)screen.getMenu().getType());
            }
            catch (UnsupportedOperationException e) {
                type = null;
            }
            graphics.drawCenteredString(Minecraft.getInstance().font, String.valueOf(type), ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2, -50, 0xFFFFFF);
            graphics.drawCenteredString(Minecraft.getInstance().font, screen.getClass().getName(), ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2, -40, 0xFFFFFF);
            for (Slot slot : screen.getMenu().slots) {
                graphics.drawString(Minecraft.getInstance().font, "" + slot.index, slot.x, slot.y, 0xFFFFFF);
            }
        }
    }

    private static EventResult keyReleased(Minecraft minecraft, Screen screen, int keyCode, int scanCode, int modifiers) {
        if (sortKeyMapping.matches(keyCode, scanCode)) {
            KeyMapping.click((InputConstants.Key)InputConstants.Type.KEYSYM.getOrCreate(keyCode));
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private static EventResult mouseReleased(Minecraft minecraft, Screen screen, double x, double y, int button) {
        if (sortKeyMapping.matchesMouse(button)) {
            KeyMapping.click((InputConstants.Key)InputConstants.Type.MOUSE.getOrCreate(button));
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    static {
        isClientSortingForced = false;
        isSlotIndexOverlayEnabled = false;
    }
}

