/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.sort_it_out.client;

import io.github.jamalam360.sort_it_out.SortItOut;
import io.github.jamalam360.sort_it_out.client.Config;
import io.github.jamalam360.sort_it_out.client.SortItOutClient;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;

public class ClientPacketWorkQueue {
    public static final ClientPacketWorkQueue INSTANCE = new ClientPacketWorkQueue();
    private final Queue<ClickAction> workQueue = new LinkedList<ClickAction>();
    private int ticks = 0;

    private ClientPacketWorkQueue() {
    }

    public boolean hasWorkRemaining() {
        return !this.workQueue.isEmpty();
    }

    public void submit(ClickAction action) {
        this.workQueue.offer(action);
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks >= ((Config)SortItOutClient.CONFIG.get()).packetSendInterval) {
            this.ticks = 0;
            this.poll();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void poll() {
        ServerboundContainerClickPacket packet;
        block3: {
            block2: {
                ClickAction action = this.workQueue.poll();
                if (action == null) return;
                if (Minecraft.getInstance().getConnection() == null) return;
                packet = action.toPacket();
                if (Minecraft.getInstance().screen == null) break block2;
                Screen screen = Minecraft.getInstance().screen;
                if (!(screen instanceof AbstractContainerScreen)) break block3;
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                if (containerScreen.getMenu().containerId == packet.getContainerId()) break block3;
            }
            SortItOut.LOGGER.info("Aborting sort as the player closed the container window before it was completed");
            this.workQueue.clear();
            return;
        }
        Minecraft.getInstance().getConnection().send((Packet)packet);
    }

    public static interface ClickAction {
        public ServerboundContainerClickPacket toPacket();
    }

    public record PlaceItem(AbstractContainerMenu menu, int slot, ItemStack newSlotItem, ItemStack newCarriedItem) implements ClickAction
    {
        @Override
        public ServerboundContainerClickPacket toPacket() {
            return new ServerboundContainerClickPacket(this.menu().containerId, this.menu().getStateId(), this.slot(), 0, ClickType.PICKUP, this.newCarriedItem(), Int2ObjectMaps.singleton((int)this.slot(), (Object)this.newSlotItem()));
        }
    }

    public record PickupItemAction(AbstractContainerMenu menu, int slot, ItemStack pickedUp) implements ClickAction
    {
        @Override
        public ServerboundContainerClickPacket toPacket() {
            return new ServerboundContainerClickPacket(this.menu().containerId, this.menu().getStateId(), this.slot(), 0, ClickType.PICKUP, this.pickedUp(), Int2ObjectMaps.singleton((int)this.slot(), (Object)ItemStack.EMPTY));
        }
    }
}

