/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

public class LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"logic_programmer_value_type_recipe_slot_properties_value_changed"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket> CODEC = LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket.getCodec(LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket::new);
    @CodecField
    private int slot;
    @CodecField
    private boolean nbt;
    @CodecField
    private String tag;
    @CodecField
    private int tagQuantity;
    @CodecField
    private boolean reusable;

    public LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket() {
        super(ID);
    }

    public LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket(int slot, boolean nbt, String tag, int tagQuantity, boolean reusable) {
        super(ID);
        this.slot = slot;
        this.nbt = nbt;
        this.tag = tag;
        this.tagQuantity = tagQuantity;
        this.reusable = reusable;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ILogicProgrammerElement element;
        if (player.containerMenu instanceof ContainerLogicProgrammerBase && (element = ((ContainerLogicProgrammerBase)player.containerMenu).getActiveElement()) instanceof ValueTypeRecipeLPElement) {
            ItemMatchProperties props = (ItemMatchProperties)((ValueTypeRecipeLPElement)element).getInputStacks().get(this.slot);
            props.setNbt(this.nbt);
            props.setItemTag(this.tag.isEmpty() ? null : this.tag);
            props.setTagQuantity(this.tagQuantity);
            props.setReusable(this.reusable);
            ((ContainerLogicProgrammerBase)player.containerMenu).onDirty();
        }
    }
}

