/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageMutable;

public class LootFunctionCopyEnergyBatteryData
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionCopyEnergyBatteryData> CODEC = RecordCodecBuilder.mapCodec(builder -> LootFunctionCopyEnergyBatteryData.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyEnergyBatteryData::new));
    public static final LootItemFunctionType<LootFunctionCopyEnergyBatteryData> TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyEnergyBatteryData(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        IEnergyStorage energyStorage;
        BlockEntity tile = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BlockEntityEnergyBattery && (energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            ((IEnergyStorageMutable)energyStorage).setEnergy(((BlockEntityEnergyBattery)tile).getEnergyStored());
            ((IEnergyStorageCapacity)energyStorage).setCapacity(((BlockEntityEnergyBattery)tile).getMaxEnergyStored());
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

