/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect.property;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;

public class AspectPropertyTypeInstance<T extends IValueType<V>, V extends IValue>
implements IAspectPropertyTypeInstance<T, V> {
    private final T type;
    private final String translationKey;
    private final Predicate<V> validator;

    public AspectPropertyTypeInstance(T type, String translationKey) {
        this(type, translationKey, (Predicate<V>)Predicates.alwaysTrue());
    }

    public AspectPropertyTypeInstance(T type, String translationKey, Predicate<V> validator) {
        this.type = type;
        this.translationKey = translationKey;
        this.validator = validator;
    }

    public boolean equals(Object o) {
        return o instanceof AspectPropertyTypeInstance && ((AspectPropertyTypeInstance)o).type.equals(this.type) && ((AspectPropertyTypeInstance)o).translationKey.equals(this.translationKey);
    }

    public int hashCode() {
        return this.translationKey.hashCode() + this.type.hashCode() << 13;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public Predicate<V> getValidator() {
        return this.validator;
    }

    public String toString() {
        return "AspectPropertyTypeInstance(type=" + String.valueOf(this.getType()) + ", translationKey=" + this.getTranslationKey() + ", validator=" + String.valueOf(this.getValidator()) + ")";
    }
}

