/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.AttachCapabilitiesEventPart;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.part.PartStateOffsetHandler;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartStateBase<P extends IPartType>
implements IPartState<P>,
IDirtyMarkListener {
    private boolean dirty = false;
    private boolean update = false;
    private boolean forceBlockUpdateRender = false;
    private int updateInterval = this.getDefaultUpdateInterval();
    private int priority = 0;
    private int channel = 0;
    private int maxOffset;
    private Vec3i targetOffset = new Vec3i(0, 0, 0);
    private Direction targetSide = null;
    private int id = -1;
    private Map<IAspect, IAspectProperties> aspectProperties = new IdentityHashMap<IAspect, IAspectProperties>();
    private boolean enabled = true;
    private final Map<String, NonNullList<ItemStack>> inventoriesNamed = Maps.newHashMap();
    private final PartStateOffsetHandler<P> offsetHandler = new PartStateOffsetHandler();
    private IdentityHashMap<PartCapability<?>, Optional<Object>> volatileCapabilities = new IdentityHashMap();

    @Override
    public void writeToNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
        tag.putInt("updateInterval", this.updateInterval);
        tag.putInt("priority", this.priority);
        tag.putInt("channel", this.channel);
        if (this.targetSide != null) {
            tag.putInt("targetSide", this.targetSide.ordinal());
        }
        tag.putInt("id", this.id);
        this.writeAspectProperties(valueDeseralizationContext, "aspectProperties", tag);
        tag.putBoolean("enabled", this.enabled);
        tag.putInt("maxOffset", this.maxOffset);
        tag.putInt("offsetX", this.targetOffset.getX());
        tag.putInt("offsetY", this.targetOffset.getY());
        tag.putInt("offsetZ", this.targetOffset.getZ());
        ListTag namedInventoriesList = new ListTag();
        for (Map.Entry<String, NonNullList<ItemStack>> entry : this.inventoriesNamed.entrySet()) {
            CompoundTag listEntry = new CompoundTag();
            listEntry.putString("tabName", entry.getKey());
            listEntry.putInt("itemCount", entry.getValue().size());
            ContainerHelper.saveAllItems((CompoundTag)listEntry, entry.getValue(), (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
            namedInventoriesList.add((Object)listEntry);
        }
        tag.put("inventoriesNamed", (Tag)namedInventoriesList);
        CompoundTag errorsTag = new CompoundTag();
        for (Int2ObjectMap.Entry entry : this.offsetHandler.offsetVariablesSlotMessages.int2ObjectEntrySet()) {
            NBTClassType.writeNbt(MutableComponent.class, (String)String.valueOf(entry.getIntKey()), (Object)((MutableComponent)entry.getValue()), (CompoundTag)errorsTag, (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
        }
        tag.put("offsetVariablesSlotMessages", (Tag)errorsTag);
    }

    @Override
    public void readFromNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
        this.updateInterval = tag.getInt("updateInterval");
        this.priority = tag.getInt("priority");
        this.channel = tag.getInt("channel");
        if (tag.contains("targetSide", 3)) {
            this.targetSide = Direction.values()[tag.getInt("targetSide")];
        }
        this.id = tag.getInt("id");
        this.aspectProperties.clear();
        this.readAspectProperties(valueDeseralizationContext, "aspectProperties", tag);
        this.enabled = tag.getBoolean("enabled");
        this.maxOffset = tag.getInt("maxOffset");
        this.targetOffset = new Vec3i(tag.getInt("offsetX"), tag.getInt("offsetY"), tag.getInt("offsetZ"));
        for (Tag listEntry : tag.getList("inventoriesNamed", 10)) {
            NonNullList list = NonNullList.withSize((int)((CompoundTag)listEntry).getInt("itemCount"), (Object)ItemStack.EMPTY);
            String tabName = ((CompoundTag)listEntry).getString("tabName");
            ContainerHelper.loadAllItems((CompoundTag)((CompoundTag)listEntry), (NonNullList)list, (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
            this.inventoriesNamed.put(tabName, (NonNullList<ItemStack>)list);
        }
        this.offsetHandler.offsetVariablesSlotMessages.clear();
        CompoundTag errorsTag = tag.getCompound("offsetVariablesSlotMessages");
        for (String slot : errorsTag.getAllKeys()) {
            MutableComponent unlocalizedString = (MutableComponent)NBTClassType.readNbt(MutableComponent.class, (String)slot, (CompoundTag)errorsTag, (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
            this.offsetHandler.offsetVariablesSlotMessages.put(Integer.parseInt(slot), (Object)unlocalizedString);
        }
    }

    protected void writeAspectProperties(ValueDeseralizationContext valueDeseralizationContext, String name, CompoundTag tag) {
        CompoundTag mapTag = new CompoundTag();
        ListTag list = new ListTag();
        for (Map.Entry<IAspect, IAspectProperties> entry : this.aspectProperties.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putString("key", entry.getKey().getUniqueName().toString());
            if (entry.getValue() != null) {
                entryTag.put("value", (Tag)entry.getValue().toNBT(valueDeseralizationContext));
            }
            list.add((Object)entryTag);
        }
        mapTag.put("map", (Tag)list);
        tag.put(name, (Tag)mapTag);
    }

    public void readAspectProperties(ValueDeseralizationContext valueDeseralizationContext, String name, CompoundTag tag) {
        CompoundTag mapTag = tag.getCompound(name);
        ListTag list = mapTag.getList("map", 10);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entryTag = list.getCompound(i);
                IAspect key = Aspects.REGISTRY.getAspect(ResourceLocation.parse((String)entryTag.getString("key")));
                AspectProperties value = null;
                if (entryTag.contains("value")) {
                    value = new AspectProperties();
                    value.fromNBT(valueDeseralizationContext, entryTag.getCompound("value"));
                }
                if (key == null || value == null) continue;
                this.aspectProperties.put(key, value);
            }
        }
    }

    @Override
    public void generateId() {
        this.id = IntegratedDynamics.globalCounters.getNext("part");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public Vec3i getTargetOffset() {
        return this.targetOffset;
    }

    @Override
    public void setTargetOffset(Vec3i targetOffset) {
        this.targetOffset = targetOffset;
        this.markDirty();
    }

    @Override
    public void setTargetSideOverride(Direction targetSide) {
        this.targetSide = targetSide;
    }

    @Override
    @Nullable
    public Direction getTargetSideOverride() {
        return this.targetSide;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirtyAndReset() {
        boolean wasDirty = this.dirty;
        this.dirty = false;
        return wasDirty;
    }

    @Override
    public boolean isUpdateAndReset() {
        boolean wasUpdate = this.update;
        this.update = false;
        return wasUpdate;
    }

    @Override
    public void forceBlockRenderUpdate() {
        this.forceBlockUpdateRender = true;
    }

    @Override
    public boolean isForceBlockRenderUpdateAndReset() {
        boolean wasForceBlockUpdateRender = this.forceBlockUpdateRender;
        this.forceBlockUpdateRender = false;
        return wasForceBlockUpdateRender;
    }

    public void onDirty() {
        this.dirty = true;
        this.forceBlockRenderUpdate();
    }

    public void sendUpdate() {
        this.update = true;
    }

    @Override
    public IAspectProperties getAspectProperties(IAspect aspect) {
        return this.aspectProperties.get(aspect);
    }

    @Override
    public void setAspectProperties(IAspect aspect, IAspectProperties properties) {
        this.aspectProperties.put(aspect, properties);
        this.sendUpdate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (this.enabled != wasEnabled) {
            this.sendUpdate();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public NonNullList<ItemStack> getInventoryNamed(String name) {
        return this.inventoriesNamed.get(name);
    }

    @Override
    public void setInventoryNamed(String name, NonNullList<ItemStack> inventory) {
        this.inventoriesNamed.put(name, inventory);
        this.onDirty();
    }

    @Override
    public Map<String, NonNullList<ItemStack>> getInventoriesNamed() {
        return this.inventoriesNamed;
    }

    @Override
    public void clearInventoriesNamed() {
        this.inventoriesNamed.clear();
    }

    @Override
    public void gatherCapabilities(P partType) {
        AttachCapabilitiesEventPart event = new AttachCapabilitiesEventPart((IPartType)partType, this);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public <T> Optional<T> getCapability(P partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        Optional<Object> o = this.volatileCapabilities.get(capability);
        if (o != null && o.isPresent()) {
            return o;
        }
        return Optional.ofNullable(capability.getCapability((IPartType<?, ?>)partType, target));
    }

    @Override
    public <T> void addVolatileCapability(PartCapability<T> capability, Optional<T> value) {
        this.volatileCapabilities.put(capability, value);
    }

    @Override
    public void removeVolatileCapability(PartCapability<?> capability) {
        this.volatileCapabilities.remove(capability);
    }

    protected int getDefaultUpdateInterval() {
        return GeneralConfig.defaultPartUpdateFreq;
    }

    @Override
    public void initializeOffsets(PartTarget target) {
        this.offsetHandler.initializeVariableEvaluators(this.offsetHandler.getOffsetVariablesInventory(this), target);
    }

    @Override
    public void updateOffsetVariables(P partType, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        this.offsetHandler.updateOffsetVariables(partType, this, network, partNetwork, target);
    }

    @Override
    @Nullable
    public MutableComponent getOffsetVariableError(int slot) {
        return this.offsetHandler.getOffsetVariableError(slot);
    }

    @Override
    public boolean requiresOffsetUpdates() {
        return this.offsetHandler.offsetVariableEvaluators.stream().anyMatch(InventoryVariableEvaluator::hasVariable);
    }

    @Override
    public void markOffsetVariablesChanged() {
        this.offsetHandler.markOffsetVariablesChanged();
    }

    @Override
    public int getMaxOffset() {
        return this.maxOffset;
    }

    @Override
    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
        this.markDirty();
    }
}

