/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.block.BlockCreativeEnergyBattery;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.client.render.blockentity.ItemStackBlockEntityEnergyBatteryRender;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainerAutoSupply;

public class BlockCreativeEnergyBatteryConfig
extends BlockConfig {
    public BlockCreativeEnergyBatteryConfig() {
        super((ModBase)IntegratedDynamics._instance, "energy_battery_creative", eConfig -> new BlockCreativeEnergyBattery(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2.0f, 5.0f)), (eConfig, block) -> new ItemBlockEnergyContainerAutoSupply((Block)block, new Item.Properties()){

            @OnlyIn(value=Dist.CLIENT)
            public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                consumer.accept(new IClientItemExtensions(this){

                    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                        return new ItemStackBlockEntityEnergyBatteryRender();
                    }
                });
            }
        });
        IntegratedDynamics._instance.getModEventBus().addListener(this::registerCapability);
        IntegratedDynamics._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    protected void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> ((ItemBlockEnergyContainer)this.getItemInstance()).createCapability((ItemStack)stack), new ItemLike[]{(ItemLike)this.getInstance()});
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == IntegratedDynamics._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> defaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        ArrayList itemStacks = Lists.newArrayList();
        ItemStack full = new ItemStack((ItemLike)this.getInstance());
        IEnergyStorageCapacity energyStorage = ((ItemBlockEnergyContainer)full.getItem()).getEnergyBattery(full).orElse(null);
        BlockCreativeEnergyBattery cfr_ignored_0 = (BlockCreativeEnergyBattery)((Object)this.getInstance());
        BlockCreativeEnergyBattery.fill(energyStorage);
        itemStacks.add(full);
        return itemStacks;
    }
}

