/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.capability;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.client.RecipesWidget;
import com.illusivesoulworks.polymorph.common.capability.AbstractRecipeData;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PlayerRecipeData
extends AbstractRecipeData<Player>
implements IPlayerRecipeData {
    private AbstractContainerMenu containerMenu;
    private RecipeHolder<?> cachedSelection;
    private int lastAccessTick;

    public PlayerRecipeData(Player owner) {
        super(owner);
    }

    @Override
    public <I extends RecipeInput, T extends Recipe<I>> RecipeHolder<T> getRecipe(RecipeType<T> type, I recipeInput, Level level, List<RecipeHolder<T>> recipesList) {
        if (((Player)this.getOwner()).tickCount == this.lastAccessTick) {
            if (this.cachedSelection != null) {
                this.setSelectedRecipe(this.cachedSelection);
            }
        } else {
            this.cachedSelection = null;
        }
        RecipeHolder<T> result = super.getRecipe(type, recipeInput, level, recipesList);
        if (this.getContainerMenu() == ((Player)this.getOwner()).containerMenu) {
            this.syncPlayerRecipeData();
        }
        this.setContainerMenu(null);
        if (((Player)this.getOwner()).tickCount != this.lastAccessTick) {
            this.lastAccessTick = ((Player)this.getOwner()).tickCount;
            if (this.validateThread(level)) {
                this.cachedSelection = result;
            }
        }
        return result;
    }

    private boolean validateThread(Level level) {
        MinecraftServer server = level.getServer();
        return server != null && server.getRunningThread() == Thread.currentThread();
    }

    @Override
    public void selectRecipe(@Nonnull RecipeHolder<?> recipe) {
        this.cachedSelection = null;
        super.selectRecipe(recipe);
        this.syncPlayerRecipeData();
    }

    private void syncPlayerRecipeData() {
        if (this.getOwner() instanceof ServerPlayer) {
            ResourceLocation resourceLocation = this.getSelectedRecipe() != null ? this.getSelectedRecipe().id() : null;
            PolymorphApi.getInstance().getNetwork().sendPlayerSyncS2C((ServerPlayer)this.getOwner(), this.getRecipesList(), resourceLocation);
        }
    }

    @Override
    public void sendRecipesListToListeners() {
        if (this.getContainerMenu() == ((Player)this.getOwner()).containerMenu) {
            ResourceLocation resourceLocation = this.getSelectedRecipe() != null ? this.getSelectedRecipe().id() : null;
            Pair packetData = new Pair(this.getRecipesList(), (Object)resourceLocation);
            Player player = (Player)this.getOwner();
            if (player.level().isClientSide()) {
                RecipesWidget.get().ifPresent(widget -> widget.setRecipesList((Set)packetData.getFirst(), (ResourceLocation)packetData.getSecond()));
            } else if (player instanceof ServerPlayer) {
                PolymorphApi.getInstance().getNetwork().sendRecipesListS2C((ServerPlayer)player, (SortedSet)packetData.getFirst(), (ResourceLocation)packetData.getSecond());
            }
        }
    }

    @Override
    public void setContainerMenu(AbstractContainerMenu containerMenu) {
        this.containerMenu = containerMenu;
    }

    @Override
    public AbstractContainerMenu getContainerMenu() {
        return this.containerMenu;
    }
}

