/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.access.PlayerRendererAccess;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={PlayerRenderer.class}, priority=500)
public abstract class PlayerRendererMixin
extends LivingEntityRenderer
implements PlayerRendererAccess {
    private static Minecraft fpmMcInstance = Minecraft.getInstance();
    private List<RenderLayer> removedLayers = new ArrayList<RenderLayer>();

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel model, float shadowRadius) {
        super(context, (EntityModel)model, shadowRadius);
    }

    @Override
    public List<RenderLayer> getRenderLayers() {
        ArrayList<RenderLayer> layers = new ArrayList<RenderLayer>(this.layers);
        layers.addAll(this.removedLayers);
        return layers;
    }

    @Override
    public void updatePartsList(boolean thirdperson) {
        this.layers.addAll(this.removedLayers);
        this.removedLayers.clear();
        if (thirdperson) {
            return;
        }
        for (Object layerObj : this.layers) {
            RenderLayer layer = (RenderLayer)layerObj;
            if (!FirstPersonModelCore.instance.getConfig().hiddenLayers.contains(layer.getClass().getName())) continue;
            this.removedLayers.add(layer);
        }
        this.layers.removeAll(this.removedLayers);
    }
}

