/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.util;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RaycastUtil {
    public static HitResult pickFilteredBlockFromPos(Level world, Vec3 from, Vec3 dir, float distance, Predicate<BlockState> p) {
        Vec3 to = from.add(dir.x * (double)distance, dir.y * (double)distance, dir.z * (double)distance);
        return (HitResult)BlockGetter.traverseBlocks((Vec3)from, (Vec3)to, null, (context, pos) -> {
            BlockState blockState = world.getBlockState(pos);
            VoxelShape voxelShape = ClipContext.Block.OUTLINE.get(blockState, (BlockGetter)world, pos, null);
            BlockHitResult blockHitResult = world.clipWithInteractionOverride(from, to, pos, voxelShape, blockState);
            return p.test(blockState) ? blockHitResult : null;
        }, context -> {
            Vec3 vec3 = from.subtract(to);
            return BlockHitResult.miss((Vec3)to, (Direction)Direction.getNearest((double)vec3.x, (double)vec3.y, (double)vec3.z), (BlockPos)BlockPos.containing((Position)to));
        });
    }
}

