/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Tuple;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.network.NetworkPath;
import org.antarcticgardens.cna.util.HashSortedPair;

public class NetworkPathConductivityContext {
    private final Map<HashSortedPair<ElectricalConnectorBlockEntity>, Tuple<Long, Long>> connections = new HashMap<HashSortedPair<ElectricalConnectorBlockEntity>, Tuple<Long, Long>>();

    public NetworkPathConductivityContext() {
    }

    public NetworkPathConductivityContext(NetworkPathConductivityContext context) {
        for (Map.Entry<HashSortedPair<ElectricalConnectorBlockEntity>, Tuple<Long, Long>> e : context.connections.entrySet()) {
            this.connections.put(e.getKey(), (Tuple<Long, Long>)new Tuple((Object)((Long)e.getValue().getA()), (Object)((Long)e.getValue().getB())));
        }
    }

    public void addConnection(ElectricalConnectorBlockEntity node, ElectricalConnectorBlockEntity node1) {
        if (!((Object)((Object)node)).equals((Object)node1) && !this.connections.containsKey(new HashSortedPair<ElectricalConnectorBlockEntity>(node, node1))) {
            this.connections.put(new HashSortedPair<ElectricalConnectorBlockEntity>(node, node1), (Tuple<Long, Long>)new Tuple((Object)node.getConnectedConnectors().get((Object)node1).getConductivity(), (Object)0L));
        }
    }

    protected long calculatePathConductivity(NetworkPath path) {
        ElectricalConnectorBlockEntity prevNode = null;
        long conductivity = Long.MAX_VALUE;
        for (ElectricalConnectorBlockEntity node : path.getNodes()) {
            if (prevNode == null) {
                prevNode = node;
                continue;
            }
            HashSortedPair<ElectricalConnectorBlockEntity> key = new HashSortedPair<ElectricalConnectorBlockEntity>(prevNode, node);
            if (!this.connections.containsKey(key)) {
                return 0L;
            }
            long connectionConductivity = (Long)this.connections.get(key).getB();
            conductivity = Math.min(connectionConductivity, conductivity);
            prevNode = node;
        }
        return conductivity;
    }

    protected void decreasePathConductivity(NetworkPath path, long amount) {
        ElectricalConnectorBlockEntity prevNode = null;
        for (ElectricalConnectorBlockEntity node : path.getNodes()) {
            if (prevNode == null) {
                prevNode = node;
                continue;
            }
            HashSortedPair<ElectricalConnectorBlockEntity> key = new HashSortedPair<ElectricalConnectorBlockEntity>(prevNode, node);
            long connectionConductivity = (Long)this.connections.get(key).getB();
            this.connections.get(key).setB((Object)(connectionConductivity - amount));
            prevNode = node;
        }
    }

    protected long getConnectionConductivity(HashSortedPair<ElectricalConnectorBlockEntity> key) {
        return (Long)this.connections.get(key).getB();
    }

    protected void updateConductivity() {
        for (Map.Entry<HashSortedPair<ElectricalConnectorBlockEntity>, Tuple<Long, Long>> e : this.connections.entrySet()) {
            this.connections.get(e.getKey()).setB((Object)((Long)e.getValue().getA()));
        }
    }
}

