/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.generation.magnet;

import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.CNATags;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.generation.coil.GeneratorCoilBlockEntity;

public class MagnetPlacementHelper
implements IPlacementHelper {
    public Predicate<ItemStack> getItemPredicate() {
        return is -> is.is(CNATags.Block.MAGNET.itemTag);
    }

    public Predicate<BlockState> getStatePredicate() {
        return bs -> bs.is((Block)CNABlocks.GENERATOR_COIL.get());
    }

    public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
        BlockEntity blockEntity = world.getBlockEntity(ray.getBlockPos());
        if (blockEntity instanceof GeneratorCoilBlockEntity) {
            GeneratorCoilBlockEntity coil = (GeneratorCoilBlockEntity)blockEntity;
            PlacementOffset offset = this.checkCoil(coil);
            if (offset == null) {
                for (int i = 0; i < (Integer)CNAConfig.getCommon().maxCoils.get(); ++i) {
                    GeneratorCoilBlockEntity c;
                    BlockEntity blockEntity2 = world.getBlockEntity(ray.getBlockPos().relative((Direction.Axis)coil.getBlockState().getValue((Property)BlockStateProperties.AXIS), i));
                    if (blockEntity2 instanceof GeneratorCoilBlockEntity && (offset = this.checkCoil(c = (GeneratorCoilBlockEntity)blockEntity2)) != null) {
                        return offset;
                    }
                    blockEntity2 = world.getBlockEntity(ray.getBlockPos().relative((Direction.Axis)coil.getBlockState().getValue((Property)BlockStateProperties.AXIS), -i));
                    if (!(blockEntity2 instanceof GeneratorCoilBlockEntity) || (offset = this.checkCoil(c = (GeneratorCoilBlockEntity)blockEntity2)) == null) continue;
                    return offset;
                }
            } else {
                return offset;
            }
        }
        return PlacementOffset.fail();
    }

    private PlacementOffset checkCoil(GeneratorCoilBlockEntity coil) {
        for (BlockPos magnetPos : coil.magnetPositions) {
            if (!coil.getLevel().getBlockState(magnetPos).canBeReplaced()) continue;
            return PlacementOffset.success((Vec3i)magnetPos);
        }
        return null;
    }
}

