/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.connector;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.cna.CNARenderTypes;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.connector.Wire;
import org.antarcticgardens.cna.content.electricity.connector.WireSection;
import org.antarcticgardens.cna.content.electricity.wire.ElectricWireItem;
import org.antarcticgardens.cna.content.electricity.wire.WireType;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ElectricalConnectorRenderer
implements BlockEntityRenderer<ElectricalConnectorBlockEntity> {
    public ElectricalConnectorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static HitResult pickBlockFromPos(Level world, Vec3 pos, Vec3 dir, double distance) {
        Vec3 vec33 = pos.add(dir.x * distance, dir.y * distance, dir.z * distance);
        return world.clip(new ClipContext(pos, vec33, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)Minecraft.getInstance().player));
    }

    public void render(ElectricalConnectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.renderAllConnections(blockEntity, poseStack, buffer);
        this.renderHand(blockEntity, partialTick, poseStack, buffer);
    }

    public void renderAllConnections(ElectricalConnectorBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource buffer) {
        blockEntity.getConnectorPositions().entrySet().stream().forEach(e -> this.renderConnection(blockEntity.getBlockPos(), (BlockPos)e.getKey(), (WireType)((Object)((Object)e.getValue())), poseStack, buffer, blockEntity.getLevel()));
    }

    public boolean shouldRenderConnection(BlockPos pos, BlockPos endPos) {
        if (pos.getX() < endPos.getX()) {
            return true;
        }
        if (pos.getX() == endPos.getX()) {
            if (pos.getY() < endPos.getY()) {
                return true;
            }
            if (pos.getY() == endPos.getY() && pos.getZ() < endPos.getZ()) {
                return true;
            }
        }
        return false;
    }

    public void renderConnection(BlockPos pos, BlockPos endPos, WireType wireType, PoseStack poseStack, MultiBufferSource buffer, Level level) {
        if (!this.shouldRenderConnection(pos, endPos)) {
            return;
        }
        ResourceLocation texture = wireType.getTextureLocation();
        double distance = pos.getCenter().distanceTo(endPos.getCenter());
        int sections = (int)Math.ceil(distance * (double)((Integer)CNAConfig.getClient().wireSectionsPerMeter.get()).intValue());
        Vector3f direction = endPos.getCenter().subtract(pos.getCenter()).normalize().toVector3f();
        Wire wire = new Wire(direction, (float)distance, sections);
        VertexConsumer consumer = buffer.getBuffer(CNARenderTypes.wire(texture));
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(new Matrix4f().rotateTowards((Vector3fc)wire.getDirection(), (Vector3fc)wire.getUp()));
        for (int i = 0; i < wire.getSections().size(); ++i) {
            Pair<WireSection, Float> pair = wire.getSections().get(i);
            float sectionOffset = wire.getSectionLength() * (float)i;
            Vector3f lightPos = pos.getCenter().toVector3f().add((Vector3fc)wire.getDirection().mul(sectionOffset)).add((Vector3fc)wire.getUp().mul(((Float)pair.getSecond()).floatValue()));
            BlockPos lightBlockPos = BlockPos.containing((Position)new Vec3(lightPos));
            int block = level.getBrightness(LightLayer.BLOCK, lightBlockPos);
            int sky = level.getBrightness(LightLayer.SKY, lightBlockPos);
            ((WireSection)pair.getFirst()).render(consumer, poseStack, LightTexture.pack((int)block, (int)sky), ((Float)pair.getSecond()).floatValue());
            poseStack.translate(0.0f, 0.0f, wire.getSectionLength());
        }
        poseStack.popPose();
    }

    public void renderHand(ElectricalConnectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            ElectricWireItem wireItem;
            BlockPos bound;
            Item item;
            ItemStack itemInHand = player.getMainHandItem();
            if (!(itemInHand.getItem() instanceof ElectricWireItem)) {
                itemInHand = player.getOffhandItem();
            }
            if ((item = itemInHand.getItem()) instanceof ElectricWireItem && (bound = (wireItem = (ElectricWireItem)item).getBoundConnector(itemInHand)) != null && bound.equals((Object)blockEntity.getBlockPos())) {
                int maxDistance;
                Vec3 eyePos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                Vec3 endPos = eyePos.add(player.getViewVector(partialTick).normalize().scale(2.0));
                HitResult hit = ElectricalConnectorRenderer.pickBlockFromPos(blockEntity.getLevel(), eyePos, player.getViewVector(partialTick), Minecraft.getInstance().player.blockInteractionRange());
                if (hit instanceof BlockHitResult) {
                    BlockHitResult blockHit = (BlockHitResult)hit;
                    Vec3 vec = eyePos.add(blockHit.getLocation().subtract(eyePos).scale((double)0.9f));
                    if (eyePos.distanceTo(endPos) > eyePos.distanceTo(vec)) {
                        endPos = vec;
                    }
                }
                BlockPos pos = blockEntity.getBlockPos();
                Vector3f to = new Vector3f((float)(endPos.x - (double)pos.getX() - 0.5), (float)(endPos.y - (double)pos.getY() - 0.5), (float)(endPos.z - (double)pos.getZ() - 0.5));
                double distance = endPos.distanceTo(bound.getCenter());
                if (distance > (double)((maxDistance = ((Integer)CNAConfig.getCommon().maxWireLength.get()).intValue()) * 2)) {
                    return;
                }
                if (Minecraft.getInstance().gameMode != null && hit instanceof BlockHitResult) {
                    BlockHitResult blockHit = (BlockHitResult)hit;
                    BlockEntity blockEntity2 = blockEntity.getLevel().getBlockEntity(blockHit.getBlockPos());
                    if (blockEntity2 instanceof ElectricalConnectorBlockEntity) {
                        ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)blockEntity2;
                        if (connector.isConnected(blockEntity.getBlockPos())) {
                            return;
                        }
                        to = new Vector3f((float)(blockHit.getBlockPos().getX() - pos.getX()), (float)(blockHit.getBlockPos().getY() - pos.getY()), (float)(blockHit.getBlockPos().getZ() - pos.getZ()));
                        distance = connector.getBlockPos().getCenter().distanceTo(blockEntity.getBlockPos().getCenter());
                    }
                }
                ResourceLocation texture = wireItem.getWireType().getTextureLocation();
                if (distance >= (double)maxDistance) {
                    texture = ResourceLocation.fromNamespaceAndPath((String)"create_new_age", (String)"textures/wire/red.png");
                }
                int sections = (int)Math.ceil(distance * (double)((Integer)CNAConfig.getClient().wireSectionsPerMeter.get()).intValue());
                Vector3f direction = new Vector3f((Vector3fc)to).normalize();
                Wire wire = new Wire(direction, (float)distance, sections);
                VertexConsumer consumer = buffer.getBuffer(CNARenderTypes.wire(texture));
                poseStack.pushPose();
                poseStack.translate(0.5f, 0.5f, 0.5f);
                poseStack.mulPose(new Matrix4f().rotateTowards((Vector3fc)wire.getDirection(), (Vector3fc)wire.getUp()));
                for (int i = 0; i < wire.getSections().size(); ++i) {
                    Pair<WireSection, Float> pair = wire.getSections().get(i);
                    float sectionOffset = wire.getSectionLength() * (float)i;
                    Vector3f lightPos = blockEntity.getBlockPos().getCenter().toVector3f().add((Vector3fc)wire.getDirection().mul(sectionOffset)).add((Vector3fc)wire.getUp().mul(((Float)pair.getSecond()).floatValue()));
                    BlockPos lightBlockPos = BlockPos.containing((Position)new Vec3(lightPos));
                    int block = blockEntity.getLevel().getBrightness(LightLayer.BLOCK, lightBlockPos);
                    int sky = blockEntity.getLevel().getBrightness(LightLayer.SKY, lightBlockPos);
                    ((WireSection)pair.getFirst()).render(consumer, poseStack, LightTexture.pack((int)block, (int)sky), ((Float)pair.getSecond()).floatValue());
                    poseStack.translate(0.0f, 0.0f, wire.getSectionLength());
                }
                poseStack.popPose();
            }
        }
    }

    public boolean shouldRenderOffScreen(ElectricalConnectorBlockEntity blockEntity) {
        return true;
    }

    public AABB getRenderBoundingBox(ElectricalConnectorBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

