/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.compat.jei;

import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.Arrays;
import java.util.Collections;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.compat.RenderingUtil;
import org.antarcticgardens.cna.content.energising.recipe.EnergisingRecipe;
import org.antarcticgardens.cna.util.StringFormatUtil;

public class EnergisingJeiCategory
extends CreateRecipeCategory<EnergisingRecipe> {
    public EnergisingJeiCategory(CreateRecipeCategory.Info<EnergisingRecipe> info) {
        super(info);
    }

    public Component getTitle() {
        return Component.translatable((String)"category.create_new_age.energising");
    }

    public int getWidth() {
        return 130;
    }

    public int getHeight() {
        return 25;
    }

    public IDrawable getIcon() {
        return new ItemIcon(() -> CNABlocks.ADVANCED_ENERGISER.asStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EnergisingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 4).setBackground(EnergisingJeiCategory.getRenderedSlot(), -1, -1).addItemStacks(Arrays.asList(((Ingredient)recipe.getIngredients().get(0)).getItems()));
        int i = 0;
        for (ProcessingOutput itemStacks : recipe.getRollableResults()) {
            int xPos = 80 + i % 5 * 19;
            int yPos = 4 + i / 5 * -19;
            builder.addSlot(RecipeIngredientRole.OUTPUT, xPos, yPos).setBackground(EnergisingJeiCategory.getRenderedSlot(), -1, -1).addItemStacks(Collections.singletonList(itemStacks.getStack()));
            ++i;
        }
    }

    public void draw(EnergisingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_ARROW.render(guiGraphics, 31, 8);
        RenderingUtil.drawCenteredStringWithoutShadow(guiGraphics, Minecraft.getInstance().font, (Component)Component.literal((String)(StringFormatUtil.formatLong(recipe.getEnergyNeeded()) + " \u26a1")), 50, 18, 0x1166FF);
    }
}

