/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import java.util.function.Function;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.CNABlocks;

public class RecipeViewerEnergiserRenderer {
    private final Function<BlockState, GuiGameElement.GuiRenderBuilder> blockElement;

    public RecipeViewerEnergiserRenderer(Function<BlockState, GuiGameElement.GuiRenderBuilder> blockElement) {
        this.blockElement = blockElement;
    }

    public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        this.blockElement.apply(RecipeViewerEnergiserRenderer.shaft(Direction.Axis.Z)).rotateBlock(0.0, 0.0, (double)RecipeViewerEnergiserRenderer.getCurrentAngle()).scale(20.0).render(graphics);
        this.blockElement.apply(CNABlocks.BASIC_ENERGISER.getDefaultState()).scale(20.0).render(graphics);
        this.blockElement.apply(AllBlocks.DEPOT.getDefaultState()).scale(20.0).atLocal(0.0, 2.0, 0.0).render(graphics);
        matrixStack.popPose();
    }

    public static float getCurrentAngle() {
        return AnimationTickHolder.getRenderTime() * 4.0f % 360.0f;
    }

    public static BlockState shaft(Direction.Axis axis) {
        return (BlockState)AllBlocks.SHAFT.getDefaultState().setValue((Property)BlockStateProperties.AXIS, (Comparable)axis);
    }
}

