/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData;

import com.seibel.distanthorizons.core.dataObjects.BlockBiomeWrapperPair;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class FullDataPointIdMap {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final boolean RUN_SERIALIZATION_DUPLICATE_VALIDATION = false;
    public static final String BLOCK_STATE_SEPARATOR_STRING = "_DH-BSW_";
    private long pos;
    private final ArrayList<BlockBiomeWrapperPair> blockBiomePairList = new ArrayList();
    private final ConcurrentHashMap<BlockBiomeWrapperPair, Integer> idMap = new ConcurrentHashMap();
    private int cachedHashCode = 0;

    public FullDataPointIdMap(long pos) {
        this.pos = pos;
    }

    public IBiomeWrapper getBiomeWrapper(int id) throws IndexOutOfBoundsException {
        return this.getEntry((int)id).biome;
    }

    public IBlockStateWrapper getBlockStateWrapper(int id) throws IndexOutOfBoundsException {
        return this.getEntry((int)id).blockState;
    }

    private BlockBiomeWrapperPair getEntry(int id) throws IndexOutOfBoundsException {
        BlockBiomeWrapperPair pair;
        try {
            pair = this.blockBiomePairList.get(id);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("FullData ID Map out of sync for pos: " + DhSectionPos.toString(this.pos) + ". ID: [" + id + "] greater than the number of known ID's: [" + this.blockBiomePairList.size() + "].");
        }
        return pair;
    }

    public int getMaxValidId() {
        return this.blockBiomePairList.size() - 1;
    }

    public int size() {
        return this.blockBiomePairList.size();
    }

    public boolean isEmpty() {
        return this.blockBiomePairList.isEmpty();
    }

    public long getPos() {
        return this.pos;
    }

    public int addIfNotPresentAndGetId(IBiomeWrapper biome, IBlockStateWrapper blockState) {
        return this.addIfNotPresentAndGetId(BlockBiomeWrapperPair.get(blockState, biome));
    }

    private int addIfNotPresentAndGetId(BlockBiomeWrapperPair pair) {
        Integer nullableId = this.idMap.get(pair);
        if (nullableId != null) {
            return nullableId;
        }
        return this.idMap.compute(pair, (newPair, currentId) -> {
            if (currentId != null) {
                return currentId;
            }
            currentId = this.blockBiomePairList.size();
            this.blockBiomePairList.add((BlockBiomeWrapperPair)newPair);
            this.cachedHashCode = 0;
            return currentId;
        });
    }

    public void addAll(FullDataPointIdMap inputMap) {
        ArrayList<BlockBiomeWrapperPair> pairsToMerge = inputMap.blockBiomePairList;
        for (int i = 0; i < pairsToMerge.size(); ++i) {
            BlockBiomeWrapperPair pair = pairsToMerge.get(i);
            this.add(pair);
        }
    }

    private void add(BlockBiomeWrapperPair pair) {
        int id = this.blockBiomePairList.size();
        this.blockBiomePairList.add(pair);
        this.idMap.put(pair, id);
        this.cachedHashCode = 0;
    }

    public int[] mergeAndReturnRemappedEntityIds(FullDataPointIdMap inputMap) {
        ArrayList<BlockBiomeWrapperPair> entriesToMerge = inputMap.blockBiomePairList;
        int[] remappedPairIds = new int[entriesToMerge.size()];
        for (int i = 0; i < entriesToMerge.size(); ++i) {
            int id;
            BlockBiomeWrapperPair entity = entriesToMerge.get(i);
            remappedPairIds[i] = id = this.addIfNotPresentAndGetId(entity);
        }
        return remappedPairIds;
    }

    public void clear(long pos) {
        this.pos = pos;
        this.blockBiomePairList.clear();
        this.idMap.clear();
        this.cachedHashCode = 0;
    }

    public void serialize(DhDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.blockBiomePairList.size());
        HashMap dataPointEntryBySerialization = new HashMap();
        for (BlockBiomeWrapperPair pair : this.blockBiomePairList) {
            String entryString = pair.serialize();
            outputStream.writeUTF(entryString);
        }
    }

    public static FullDataPointIdMap deserialize(DhDataInputStream inputStream, long pos, ILevelWrapper levelWrapper) throws IOException, InterruptedException, DataCorruptedException {
        int entityCount = inputStream.readInt();
        if (entityCount < 0) {
            throw new DataCorruptedException("FullDataPointIdMap deserialize entry count should have a number greater than or equal to 0, returned value [" + entityCount + "].");
        }
        HashMap dataPointEntryBySerialization = new HashMap();
        FullDataPointIdMap newMap = new FullDataPointIdMap(pos);
        for (int i = 0; i < entityCount; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("[" + FullDataPointIdMap.class.getSimpleName() + "] deserializing interrupted.");
            }
            String entryString = inputStream.readUTF();
            BlockBiomeWrapperPair newPair = BlockBiomeWrapperPair.deserialize(entryString, levelWrapper);
            newMap.blockBiomePairList.add(newPair);
        }
        if (newMap.size() != entityCount) {
            LodUtil.assertNotReach("ID maps failed to deserialize for pos: [" + DhSectionPos.toString(pos) + "], incorrect entity count. Expected count [" + entityCount + "], actual count [" + newMap.size() + "]");
        }
        return newMap;
    }

    public boolean equals(Object other) {
        return other == this;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.generateHashCode();
        }
        return this.cachedHashCode;
    }

    private void generateHashCode() {
        int result = DhSectionPos.hashCode(this.pos);
        for (int i = 0; i < this.blockBiomePairList.size(); ++i) {
            result = 31 * result + this.blockBiomePairList.hashCode();
        }
        this.cachedHashCode = result;
    }
}

