/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui.util;

import com.mojang.math.Axis;
import it.hurts.octostudios.immersiveui.ImmersiveUI;
import it.hurts.octostudios.immersiveui.client.MouseInfo;
import it.hurts.octostudios.immersiveui.client.RenderInfo;
import it.hurts.octostudios.immersiveui.client.VariableStorage;
import it.hurts.octostudios.immersiveui.client.particle.FlameUIParticle;
import it.hurts.octostudios.immersiveui.client.particle.RarityUIParticle;
import it.hurts.octostudios.immersiveui.util.Easing;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector2f;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class CommonCode {
    public static void gooeyRenderCode(float partialTick) {
        VariableStorage.currentTime = System.currentTimeMillis();
        VariableStorage.elapsedTime = VariableStorage.currentTime - VariableStorage.lastExecutedTime;
        if (VariableStorage.elapsedTime >= 350L) {
            VariableStorage.lastExecutedTime = VariableStorage.currentTime;
        }
    }

    public static void renderFurnaceParticles(Screen screen, Slot fuelSlot, boolean burstCondition, boolean isLit, AtomicBoolean shouldBurst) {
        if (!isLit) {
            return;
        }
        Random random = new Random();
        if (burstCondition && !shouldBurst.get()) {
            shouldBurst.set(true);
            for (int ii = 0; ii < 8; ++ii) {
                FlameUIParticle particle = new FlameUIParticle(fuelSlot.x + 8 + random.nextInt(-6, 6), fuelSlot.y + 10 + random.nextInt(-6, 6), random.nextInt(16, 24));
                particle.setScreen(screen);
                particle.instantiate();
            }
        }
        if (!burstCondition && shouldBurst.get()) {
            shouldBurst.set(false);
        }
    }

    public static void renderFloating(Screen screen, GuiGraphics guiGraphics, MouseInfo mouseInfo, int i, int j, ItemStack itemStack, Random random, RenderInfo renderInfo, String string, CallbackInfo ci) {
        float scale = ImmersiveUI.CONFIG.getFloatingItemScale();
        float deltaTime = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        float amplitude = ImmersiveUI.CONFIG.getFloatingItemRotationAmplitude();
        if (mouseInfo.oX != Integer.MIN_VALUE && mouseInfo.oY != Integer.MIN_VALUE) {
            renderInfo.targetAngle = Mth.clamp((float)(-mouseInfo.deltaX / 8.0f * amplitude), (float)(-1.5707964f / (2.0f / amplitude)), (float)(1.5707964f / (2.0f / amplitude)));
            renderInfo.currentAngleVelocity += (renderInfo.targetAngle - renderInfo.currentAngle) * renderInfo.easingSpeed * deltaTime;
        }
        renderInfo.currentAngle = Mth.clamp((float)(renderInfo.currentAngle + renderInfo.currentAngleVelocity * deltaTime), (float)(-1.5707964f / (2.0f / amplitude)), (float)(1.5707964f / (2.0f / amplitude)));
        float f = renderInfo.currentAngleVelocity;
        Objects.requireNonNull(renderInfo);
        renderInfo.currentAngleVelocity = f * (float)Math.pow(0.75, deltaTime);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(i + 8), (float)(j + 8), 300.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        if (ImmersiveUI.CONFIG.isEnableFloatingItemRotation()) {
            guiGraphics.pose().mulPose(Axis.ZP.rotation(Mth.abs((float)renderInfo.currentAngle) > 0.01f ? renderInfo.currentAngle : 0.0f));
        }
        guiGraphics.renderItem(itemStack, -8, -8);
        if (ImmersiveUI.CONFIG.isEnableRarityParticles()) {
            int color;
            List<Integer> colors = itemStack.getHoverName().getSiblings().stream().map(c -> c.getStyle().getColor() == null ? 0 : c.getStyle().getColor().getValue()).toList();
            int n = color = colors.isEmpty() ? 0xFFFFFF : colors.get(random.nextInt(colors.size()));
            int n2 = colors.isEmpty() ? (itemStack.getDisplayName().getStyle().getColor() != null ? itemStack.getDisplayName().getStyle().getColor().getValue() : 0xFFFFFF) : (color = color);
            if (color != 0xFFFFFF && (Mth.abs((float)mouseInfo.deltaX) > 0.0f || Mth.abs((float)mouseInfo.deltaY) > 0.0f)) {
                Vector2f direction = new Vector2f(mouseInfo.deltaX, mouseInfo.deltaY);
                RarityUIParticle particle = new RarityUIParticle(random.nextFloat(0.5f, 0.625f) * direction.length(), random.nextInt(12, 20), (float)(i + 8) + random.nextFloat(-4.0f, 4.0f), (float)(j + 8) + random.nextFloat(-4.0f, 4.0f), -direction.x, -direction.y, random.nextFloat(-10.0f, 10.0f), color, UIParticle.Layer.SCREEN, 233.0f);
                particle.setScreen(screen);
                particle.instantiate();
            }
        }
        Font font = Minecraft.getInstance().font;
        guiGraphics.renderItemDecorations(font, itemStack, -8, -8, string);
        guiGraphics.pose().popPose();
        ci.cancel();
    }

    public static void shakeScreen(GuiGraphics guiGraphics, Screen screen, AtomicReference<Float> timer, float durationMultiplier) {
        boolean shouldShake = VariableStorage.shakeScreen.contains(screen);
        if (shouldShake) {
            VariableStorage.shakeScreen.remove(screen);
            timer.set(Float.valueOf((float)ImmersiveUI.CONFIG.getShakeTimer() * durationMultiplier));
        }
        if (!ImmersiveUI.CONFIG.isEnableScreenShake()) {
            return;
        }
        if (timer.get().floatValue() > 0.0f) {
            Random rand = new Random();
            timer.set(Float.valueOf(Mth.clamp((float)(timer.get().floatValue() - Minecraft.getInstance().getTimer().getRealtimeDeltaTicks()), (float)0.0f, (float)ImmersiveUI.CONFIG.getShakeTimer())));
            Vector2f shakeDirection = new Vector2f(rand.nextFloat(-1.0f, 1.0f), rand.nextFloat(-1.0f, 1.0f)).normalize(ImmersiveUI.CONFIG.getShakeAmplitude());
            guiGraphics.pose().translate(shakeDirection.x * (timer.get().floatValue() / (float)ImmersiveUI.CONFIG.getShakeTimer()), shakeDirection.y * (timer.get().floatValue() / (float)ImmersiveUI.CONFIG.getShakeTimer()), 0.0f);
        }
    }

    public static void floatingRenderSize(GuiGraphics guiGraphics, Slot slot, Slot hoveredSlot, Map<Slot, Float> expandingProgress) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || slot == null) {
            return;
        }
        ItemStack carried = player.containerMenu.getCarried();
        if (!carried.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)carried) && ImmersiveUI.CONFIG.isEnableMatchingItemHovering()) {
            guiGraphics.pose().translate(Mth.sin((float)((float)Minecraft.getInstance().player.tickCount * 0.215f + (float)Objects.hash(slot.x, slot.y))) * ImmersiveUI.CONFIG.getMatchingItemHoverAmplitude(), Mth.cos((float)((float)Minecraft.getInstance().player.tickCount * 0.13f + (float)Objects.hash(slot.x, slot.y))) * ImmersiveUI.CONFIG.getMatchingItemHoverAmplitude(), 0.0f);
        }
        boolean hovering = hoveredSlot == slot && (carried.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)carried));
        float deltaTime = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks() / 4.0f;
        expandingProgress.put(slot, Float.valueOf(Mth.clamp((float)(expandingProgress.getOrDefault(slot, Float.valueOf(0.0f)).floatValue() + deltaTime * (float)(hovering ? 1 : -1)), (float)0.0f, (float)1.0f)));
        float progress = Easing.lerp(1.0f, ImmersiveUI.CONFIG.getHoveredItemScale(), Easing.animate(hovering ? Easing.Type.EASE_OUT : Easing.Type.EASE_IN, expandingProgress.get(slot).floatValue()));
        guiGraphics.pose().translate((float)(slot.x + 8), (float)(slot.y + 8), 0.0f);
        guiGraphics.pose().scale(progress, progress, 1.0f);
        guiGraphics.pose().translate((float)(-slot.x - 8), (float)(-slot.y - 8), 0.0f);
    }
}

