/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.integration.mekanism;

import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import com.direwolf20.laserio.util.BaseCardCache;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.world.item.ItemStack;

public class MekanismCardCache {
    private final BaseCardCache baseCardCache;
    private final List<ChemicalStack> filteredChemicals;
    private final Reference2BooleanMap<Chemical> filterCacheChemical = new Reference2BooleanOpenHashMap();
    private final Reference2IntMap<Chemical> filterCountsChemical = new Reference2IntOpenHashMap();

    public MekanismCardCache(BaseCardCache baseCardCache) {
        this.baseCardCache = baseCardCache;
        this.filteredChemicals = this.baseCardCache.filterCard.isEmpty() ? new ArrayList<ChemicalStack>() : this.getFilteredChemicals();
    }

    public List<ChemicalStack> getFilteredChemicals() {
        ArrayList<ChemicalStack> filteredChemicals = new ArrayList<ChemicalStack>();
        ItemStack filterCard = this.baseCardCache.filterCard;
        FilterBasicHandler filterSlotHandler = filterCard.getItem() instanceof FilterBasic ? FilterBasic.getInventory(filterCard) : FilterCount.getInventory(filterCard);
        for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
            IChemicalHandler handler;
            ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
            if (itemStack.isEmpty() || (handler = (IChemicalHandler)itemStack.getCapability(MekanismStatics.getItemCapabilityForChemical())) == null) continue;
            for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                ChemicalStack chemicalStack = handler.getChemicalInTank(tank);
                if (chemicalStack.isEmpty()) continue;
                filteredChemicals.add(chemicalStack);
            }
        }
        return filteredChemicals;
    }

    public boolean isStackValidForCard(ChemicalStack testStack) {
        ItemStack filterCard = this.baseCardCache.filterCard;
        if (filterCard.isEmpty()) {
            return true;
        }
        return this.filterCacheChemical.computeIfAbsent((Object)testStack.getChemical(), key -> {
            boolean matches;
            if (filterCard.getItem() instanceof FilterTag) {
                matches = key.getTags().map(tagKey -> tagKey.location().toString().toLowerCase(Locale.ROOT)).anyMatch(this.baseCardCache.filterTags::contains);
            } else {
                Predicate<ChemicalStack> validityPredicate = filterCard.getItem() instanceof FilterMod ? stack -> stack.getTypeRegistryName().getNamespace().equals(key.getRegistryName().getNamespace()) : stack -> key == stack.getChemical();
                matches = this.filteredChemicals.stream().anyMatch(validityPredicate);
            }
            return matches == this.baseCardCache.isAllowList;
        });
    }

    public int getFilterAmt(ChemicalStack testStack) {
        ItemStack filterCard = this.baseCardCache.filterCard;
        if (filterCard.isEmpty()) {
            return 0;
        }
        if (!(filterCard.getItem() instanceof FilterCount)) {
            return -1;
        }
        return this.filterCountsChemical.computeIfAbsent((Object)testStack.getChemical(), key -> {
            FilterCountHandler filterSlotHandler = FilterCount.getInventory(filterCard);
            for (int i = 0; i < filterSlotHandler.getSlots(); ++i) {
                ChemicalStack chemicalStack;
                ItemStack itemStack = filterSlotHandler.getStackInSlot(i);
                if (itemStack.isEmpty() || (chemicalStack = MekanismStatics.getFirstChemicalOnItemStack(itemStack)).isEmpty() || key != chemicalStack.getChemical()) continue;
                return FilterCount.getSlotAmount(filterCard, i) + FilterCount.getSlotCount(filterCard, i) * 1000;
            }
            return 0;
        });
    }
}

