/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items.cards;

import com.direwolf20.laserio.common.containers.CardEnergyContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.setup.Config;
import com.direwolf20.laserio.setup.LaserIODataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CardEnergy
extends BaseCard {
    public CardEnergy() {
        this.CARDTYPE = BaseCard.CardType.ENERGY;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardEnergyContainer(windowId, playerInventory, player, itemstack), (Component)Component.translatable((String)"")), buf -> {
            ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemstack);
            buf.writeByte(-1);
        });
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public static int setEnergyExtractAmt(ItemStack card, int energyextractamt) {
        if (energyextractamt == (Integer)Config.MAX_FE_TICK.get()) {
            card.remove(LaserIODataComponents.ENERGY_CARD_EXTRACT_AMT);
        } else {
            card.set(LaserIODataComponents.ENERGY_CARD_EXTRACT_AMT, (Object)energyextractamt);
        }
        return energyextractamt;
    }

    public static int getEnergyExtractAmt(ItemStack card) {
        return (Integer)card.getOrDefault(LaserIODataComponents.ENERGY_CARD_EXTRACT_AMT, (Object)((Integer)Config.MAX_FE_TICK.get()));
    }

    public static int setExtractSpeed(ItemStack card, int energyextractspeed) {
        if (energyextractspeed == 1) {
            card.remove(LaserIODataComponents.ENERGY_CARD_EXTRACT_SPEED);
        } else {
            card.set(LaserIODataComponents.ENERGY_CARD_EXTRACT_SPEED, (Object)energyextractspeed);
        }
        return energyextractspeed;
    }

    public static int getExtractSpeed(ItemStack card) {
        return (Integer)card.getOrDefault(LaserIODataComponents.ENERGY_CARD_EXTRACT_SPEED, (Object)1);
    }

    public static int setInsertLimitPercent(ItemStack card, int limitpercent) {
        if (limitpercent == 100) {
            card.remove(LaserIODataComponents.ENERGY_CARD_INSERT_LIMIT);
        } else {
            card.set(LaserIODataComponents.ENERGY_CARD_INSERT_LIMIT, (Object)limitpercent);
        }
        return limitpercent;
    }

    public static int getInsertLimitPercent(ItemStack card) {
        return (Integer)card.getOrDefault(LaserIODataComponents.ENERGY_CARD_INSERT_LIMIT, (Object)100);
    }

    public static int setExtractLimitPercent(ItemStack card, int limitextractpercent) {
        if (limitextractpercent == 0) {
            card.remove(LaserIODataComponents.ENERGY_CARD_EXTRACT_LIMIT);
        } else {
            card.set(LaserIODataComponents.ENERGY_CARD_EXTRACT_LIMIT, (Object)limitextractpercent);
        }
        return limitextractpercent;
    }

    public static int getExtractLimitPercent(ItemStack card) {
        return (Integer)card.getOrDefault(LaserIODataComponents.ENERGY_CARD_EXTRACT_LIMIT, (Object)0);
    }
}

