/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.blockentities;

import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.setup.Registration;
import com.direwolf20.laserio.util.MiscTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LaserConnectorAdvBE
extends BaseLaserBE {
    protected GlobalPos partnerGlobalPos;

    public LaserConnectorAdvBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.LaserConnectorAdv_BE.get(), pos, state);
    }

    public GlobalPos getPartnerGlobalPos() {
        return this.partnerGlobalPos;
    }

    public void setPartnerGlobalPos(GlobalPos partnerGlobalPos) {
        this.partnerGlobalPos = partnerGlobalPos;
        this.markDirtyClient();
    }

    public boolean isPartnerNodeConnected(GlobalPos pos) {
        return this.partnerGlobalPos != null && this.partnerGlobalPos.equals((Object)pos);
    }

    public void handleAdvancedConnection(LaserConnectorAdvBE be) {
        GlobalPos connectingDimPos = new GlobalPos(be.getLevel().dimension(), be.getBlockPos());
        if (this.isPartnerNodeConnected(connectingDimPos)) {
            this.removePartnerConnection();
        } else {
            this.addPartnerConnection(connectingDimPos, be);
        }
    }

    public void addPartnerConnection(GlobalPos connectingDimPos, LaserConnectorAdvBE be) {
        if (this.getPartnerGlobalPos() != null) {
            this.removePartnerConnection();
        }
        if (be.getPartnerGlobalPos() != null) {
            be.removePartnerConnection();
        }
        this.setPartnerGlobalPos(connectingDimPos);
        be.setPartnerGlobalPos(new GlobalPos(this.getLevel().dimension(), this.getBlockPos()));
        if (this.getColor().equals(this.getDefaultColor()) && !be.getColor().equals(be.getDefaultColor())) {
            this.setColor(be.getColor(), this.getWrenchAlpha());
        } else if (be.getColor().equals(be.getDefaultColor()) && !this.getColor().equals(this.getDefaultColor())) {
            be.setColor(this.getColor(), this.getWrenchAlpha());
        } else {
            this.setColor(be.getColor(), this.getWrenchAlpha());
        }
        this.discoverAllNodes();
    }

    public void removePartnerConnection() {
        if (this.getPartnerGlobalPos() != null) {
            GlobalPos partnerDimPos = this.getPartnerGlobalPos();
            BlockEntity partnerBE = MiscTools.getLevel(this.level.getServer(), partnerDimPos).getBlockEntity(partnerDimPos.pos());
            if (partnerBE instanceof LaserConnectorAdvBE) {
                LaserConnectorAdvBE be = (LaserConnectorAdvBE)partnerBE;
                be.setPartnerGlobalPos(null);
                be.discoverAllNodes();
            }
        }
        this.setPartnerGlobalPos(null);
        this.discoverAllNodes();
    }

    @Override
    public void disconnectAllNodes() {
        this.removePartnerConnection();
        super.disconnectAllNodes();
    }

    @Override
    public void validateConnections(BlockPos originalPos) {
        GlobalPos partner = this.getPartnerGlobalPos();
        if (partner == null) {
            this.removePartnerConnection();
            super.validateConnections(originalPos);
            return;
        }
        BlockEntity be = MiscTools.getLevel(this.getLevel().getServer(), partner).getBlockEntity(partner.pos());
        if (be instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE laserConnectorAdvBE = (LaserConnectorAdvBE)be;
            this.addPartnerConnection(partner, laserConnectorAdvBE);
        } else {
            this.removePartnerConnection();
        }
        super.validateConnections(originalPos);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("partnerDimPos")) {
            this.setPartnerGlobalPos(MiscTools.nbtToGlobalPos(tag.getCompound("partnerDimPos")));
        } else {
            this.setPartnerGlobalPos(null);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.getPartnerGlobalPos() != null) {
            tag.put("partnerDimPos", (Tag)MiscTools.globalPosToNBT(this.getPartnerGlobalPos()));
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }
}

