/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import guideme.color.LightDarkMode;
import guideme.document.LytRect;
import guideme.render.GuiAssets;
import guideme.render.RectangleMerger;
import guideme.render.SpriteLayer;
import guideme.render.SpritePadding;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;

class PanelBlitter {
    private final List<LytRect> rects = new ArrayList<LytRect>();
    private final List<Rectangle> processedRects = new ArrayList<Rectangle>();
    private final SpriteSlice CENTER;
    private final SpriteSlice OUTER_TOP_LEFT;
    private final SpriteSlice OUTER_TOP_RIGHT;
    private final SpriteSlice OUTER_BOTTOM_RIGHT;
    private final SpriteSlice OUTER_BOTTOM_LEFT;
    private final SpriteSlice TOP_BORDER;
    private final SpriteSlice RIGHT_BORDER;
    private final SpriteSlice BOTTOM_BORDER;
    private final SpriteSlice LEFT_BORDER;
    private final SpriteSlice INNER_TOP_LEFT;
    private final SpriteSlice INNER_TOP_RIGHT;
    private final SpriteSlice INNER_BOTTOM_RIGHT;
    private final SpriteSlice INNER_BOTTOM_LEFT;

    public PanelBlitter(LightDarkMode mode) {
        GuiAssets.NineSliceSprite window = GuiAssets.getNineSliceSprite(GuiAssets.WINDOW_SPRITE, mode);
        GuiAssets.NineSliceSprite inner = GuiAssets.getNineSliceSprite(GuiAssets.INNER_BORDER_SPRITE, mode);
        this.CENTER = new SpriteSlice(window, 4);
        this.OUTER_TOP_LEFT = new SpriteSlice(window, 0);
        this.OUTER_TOP_RIGHT = new SpriteSlice(window, 2);
        this.OUTER_BOTTOM_RIGHT = new SpriteSlice(window, 8);
        this.OUTER_BOTTOM_LEFT = new SpriteSlice(window, 6);
        this.TOP_BORDER = new SpriteSlice(window, 1);
        this.RIGHT_BORDER = new SpriteSlice(window, 5);
        this.BOTTOM_BORDER = new SpriteSlice(window, 7);
        this.LEFT_BORDER = new SpriteSlice(window, 3);
        this.INNER_TOP_LEFT = new SpriteSlice(inner, 0);
        this.INNER_TOP_RIGHT = new SpriteSlice(inner, 2);
        this.INNER_BOTTOM_RIGHT = new SpriteSlice(inner, 8);
        this.INNER_BOTTOM_LEFT = new SpriteSlice(inner, 6);
    }

    public void addBounds(Rect2i rect) {
        this.addBounds(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void addBounds(int x, int y, int width, int height) {
        this.rects.add(new LytRect(x, y, width, height));
        this.processedRects.clear();
    }

    public void blit(GuiGraphics graphics, int xOffset, int yOffset) {
        this.blit(graphics, xOffset, yOffset, 0, -1);
    }

    public void blit(GuiGraphics graphics, int xOffset, int yOffset, int zOffset, int color) {
        SpriteLayer layer = new SpriteLayer();
        this.render(layer, 0, color);
        layer.render(graphics.pose(), xOffset, yOffset, zOffset);
    }

    public void render(SpriteLayer layer, int z, int color) {
        if (this.processedRects.size() != this.rects.size()) {
            this.processedRects.clear();
            for (LytRect lytRect : RectangleMerger.merge(this.rects)) {
                this.processedRects.add(new Rectangle(lytRect.x(), lytRect.y(), lytRect.width(), lytRect.height()));
            }
            for (Rectangle rectangle : this.processedRects) {
                for (Rectangle otherRect : this.processedRects) {
                    if (rectangle == otherRect) continue;
                    rectangle.mergeEdges(otherRect, 0);
                    rectangle.mergeEdges(otherRect, 1);
                    rectangle.mergeEdges(otherRect, 2);
                    rectangle.mergeEdges(otherRect, 3);
                }
            }
        }
        for (Rectangle rectangle : this.processedRects) {
            int outerTop = rectangle.outerTop();
            int outerRight = rectangle.outerRight();
            int outerBottom = rectangle.outerBottom();
            int outerLeft = rectangle.outerLeft();
            int innerTop = rectangle.topEdges.isEmpty() ? outerTop : outerTop + this.TOP_BORDER.height();
            int innerRight = rectangle.rightEdges.isEmpty() ? outerRight : outerRight - this.RIGHT_BORDER.width();
            int innerBottom = rectangle.bottomEdges.isEmpty() ? outerBottom : outerBottom - this.BOTTOM_BORDER.height();
            int innerLeft = rectangle.leftEdges.isEmpty() ? outerLeft : outerLeft + this.LEFT_BORDER.width();
            for (int side = 0; side < 4; ++side) {
                List<Edge> edges = rectangle.getEdgesForSide(side);
                for (Edge edge : edges) {
                    int et;
                    int er;
                    int el;
                    this.renderEdge(layer, edge.style, side, el, et, er, switch (side) {
                        case 0 -> {
                            el = Math.max(innerLeft, outerLeft + edge.start);
                            er = Math.min(innerRight, outerLeft + edge.end);
                            et = outerTop;
                            yield innerTop;
                        }
                        case 1 -> {
                            el = innerRight;
                            er = outerRight;
                            et = Math.max(innerTop, outerTop + edge.start);
                            yield Math.min(innerBottom, outerTop + edge.end);
                        }
                        case 2 -> {
                            el = Math.max(innerLeft, outerLeft + edge.start);
                            er = Math.min(innerRight, outerLeft + edge.end);
                            et = innerBottom;
                            yield outerBottom;
                        }
                        case 3 -> {
                            el = outerLeft;
                            er = innerLeft;
                            et = Math.max(innerTop, outerTop + edge.start);
                            yield Math.min(innerBottom, outerTop + edge.end);
                        }
                        default -> throw new IndexOutOfBoundsException("side");
                    }, z, color);
                }
            }
            for (int i = 0; i < rectangle.corners.length; ++i) {
                SpriteSlice cornerStyle = rectangle.corners[i];
                if (cornerStyle == null) continue;
                SpritePadding border = cornerStyle.nineSlice.padding();
                int width = switch (i) {
                    default -> border.left();
                    case 1, 2 -> border.right();
                };
                int height = switch (i) {
                    default -> border.top();
                    case 2, 3 -> border.bottom();
                };
                int x = switch (i) {
                    default -> rectangle.x;
                    case 1, 2 -> rectangle.outerRight() - width;
                };
                int y = switch (i) {
                    default -> rectangle.y;
                    case 2, 3 -> rectangle.outerBottom() - height;
                };
                cornerStyle.addQuad(layer, x, y, z, width, height, color);
            }
            this.CENTER.addQuad(layer, innerLeft, innerTop, z, innerRight - innerLeft, innerBottom - innerTop, color);
        }
    }

    private void renderEdge(SpriteLayer layer, EdgeStyle style, int side, int left, int top, int right, int bottom, int z, int color) {
        if (right <= left || bottom <= top) {
            return;
        }
        if (style == EdgeStyle.NORMAL) {
            SpriteSlice edgeStyle = switch (side) {
                default -> this.TOP_BORDER;
                case 1 -> this.RIGHT_BORDER;
                case 2 -> this.BOTTOM_BORDER;
                case 3 -> this.LEFT_BORDER;
            };
            edgeStyle.addQuad(layer, left, top, z, right - left, bottom - top, color);
        } else {
            SpriteSlice innerStartCorner;
            SpriteSlice innerEndCorner = switch (side) {
                case 0 -> {
                    innerStartCorner = this.INNER_BOTTOM_RIGHT;
                    yield this.INNER_BOTTOM_LEFT;
                }
                case 1 -> {
                    innerStartCorner = this.INNER_BOTTOM_LEFT;
                    yield this.INNER_TOP_LEFT;
                }
                case 2 -> {
                    innerStartCorner = this.INNER_TOP_RIGHT;
                    yield this.INNER_TOP_LEFT;
                }
                case 3 -> {
                    innerStartCorner = this.INNER_BOTTOM_RIGHT;
                    yield this.INNER_TOP_RIGHT;
                }
                default -> throw new IndexOutOfBoundsException("side");
            };
            if (style == EdgeStyle.INNER_FILL_NO_START) {
                innerStartCorner = null;
            } else if (style == EdgeStyle.INNER_FILL_NO_END) {
                innerEndCorner = null;
            }
            if (side == 1 || side == 3) {
                if (innerStartCorner != null) {
                    innerStartCorner.addQuad(layer, left, top, z, innerStartCorner.width(), innerStartCorner.height(), color);
                    top += innerStartCorner.height();
                }
                if (innerEndCorner != null) {
                    innerEndCorner.addQuad(layer, left, bottom - innerEndCorner.height(), z, innerEndCorner.width(), innerEndCorner.height(), color);
                    bottom -= innerEndCorner.height();
                }
            } else {
                if (innerStartCorner != null) {
                    innerStartCorner.addQuad(layer, left, top, z, innerStartCorner.width(), innerStartCorner.height(), color);
                    left += innerStartCorner.width();
                }
                if (innerEndCorner != null) {
                    innerEndCorner.addQuad(layer, right - innerEndCorner.width(), top, z, innerEndCorner.width(), innerEndCorner.height(), color);
                    right -= innerEndCorner.width();
                }
            }
            if (right - left > 0 && bottom - top > 0) {
                this.CENTER.addQuad(layer, left, top, z, right - left, bottom - top, color);
            }
        }
    }

    private record SpriteSlice(GuiAssets.NineSliceSprite nineSlice, int slice) {
        int height() {
            return this.slice / 3 == 2 ? this.nineSlice.padding().bottom() : this.nineSlice.padding().top();
        }

        int width() {
            return this.slice % 3 == 2 ? this.nineSlice.padding().right() : this.nineSlice.padding().left();
        }

        public void addQuad(SpriteLayer layer, float x, float y, float z, float width, float height, int color) {
            int row = this.slice / 3;
            int col = this.slice % 3;
            float[] uv = this.nineSlice.uv();
            float minU = uv[col];
            float maxU = uv[col + 1];
            float minV = uv[4 + row];
            float maxV = uv[4 + row + 1];
            layer.addQuad(x, y, z, width, height, color, minU, maxU, minV, maxV);
        }
    }

    private final class Rectangle {
        SpriteSlice[] corners;
        private final List<Edge> leftEdges;
        private final List<Edge> topEdges;
        private final List<Edge> rightEdges;
        private final List<Edge> bottomEdges;
        int x;
        int y;
        int width;
        int height;

        public Rectangle(int x, int y, int width, int height) {
            this.corners = new SpriteSlice[]{PanelBlitter.this.OUTER_TOP_LEFT, PanelBlitter.this.OUTER_TOP_RIGHT, PanelBlitter.this.OUTER_BOTTOM_RIGHT, PanelBlitter.this.OUTER_BOTTOM_LEFT};
            this.leftEdges = new ArrayList<Edge>();
            this.topEdges = new ArrayList<Edge>();
            this.rightEdges = new ArrayList<Edge>();
            this.bottomEdges = new ArrayList<Edge>();
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.leftEdges.add(new Edge(0, height));
            this.topEdges.add(new Edge(0, width));
            this.rightEdges.add(new Edge(0, height));
            this.bottomEdges.add(new Edge(0, width));
        }

        public int outerLeft() {
            return this.x;
        }

        public int outerTop() {
            return this.y;
        }

        public int outerRight() {
            return this.x + this.width;
        }

        public int outerBottom() {
            return this.y + this.height;
        }

        public List<Edge> getEdgesForSide(int side) {
            return switch (side) {
                case 0 -> this.topEdges;
                case 1 -> this.rightEdges;
                case 2 -> this.bottomEdges;
                case 3 -> this.leftEdges;
                default -> throw new IllegalStateException("Unexpected value: " + side);
            };
        }

        public Rectangle copy() {
            Rectangle result = new Rectangle(this.x, this.y, this.width, this.height);
            System.arraycopy(this.corners, 0, result.corners, 0, result.corners.length);
            for (int i = 0; i < 4; ++i) {
                result.getEdgesForSide(i).clear();
                result.getEdgesForSide(i).addAll(this.getEdgesForSide(i));
            }
            return result;
        }

        public void mergeEdges(Rectangle otherRect, int side) {
            List<Edge> edges = this.getEdgesForSide(side);
            if (edges.isEmpty()) {
                return;
            }
            boolean touching = switch (side) {
                case 0 -> {
                    if (this.outerTop() == otherRect.outerBottom()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (this.outerRight() == otherRect.outerLeft()) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (this.outerBottom() == otherRect.outerTop()) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (this.outerLeft() == otherRect.outerRight()) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalStateException("Unexpected value: " + side);
            };
            if (!touching) {
                return;
            }
            int ourStart = switch (side) {
                case 0, 2 -> this.x;
                case 1, 3 -> this.y;
                default -> throw new IllegalStateException("Unexpected value: " + side);
            };
            int otherStart = switch (side) {
                case 0, 2 -> otherRect.outerLeft();
                case 1, 3 -> otherRect.outerTop();
                default -> throw new IllegalStateException("Unexpected value: " + side);
            };
            int otherEnd = switch (side) {
                case 0, 2 -> otherRect.outerRight();
                case 1, 3 -> otherRect.outerBottom();
                default -> throw new IllegalStateException("Unexpected value: " + side);
            };
            ArrayList<Edge> tempEdges = new ArrayList<Edge>();
            for (Edge ourEdge : edges) {
                int edgeStart = ourStart + ourEdge.start;
                int edgeEnd = ourStart + ourEdge.end;
                if (edgeStart < otherEnd && edgeEnd > otherStart) {
                    int overhangEnd;
                    int overhangStart = otherStart - edgeStart;
                    if (overhangStart > 0) {
                        tempEdges.add(new Edge(edgeStart - ourStart, edgeStart - ourStart + overhangStart));
                    }
                    if ((overhangEnd = edgeEnd - otherEnd) > 0) {
                        tempEdges.add(new Edge(edgeEnd - ourStart - overhangEnd, edgeEnd));
                    }
                    int startCorner = switch (side) {
                        case 0, 3 -> 0;
                        case 1 -> 1;
                        case 2 -> 3;
                        default -> throw new IllegalStateException("Unexpected value: " + side);
                    };
                    int endCorner = switch (side) {
                        case 0 -> 1;
                        case 1, 2 -> 2;
                        case 3 -> 3;
                        default -> throw new IllegalStateException("Unexpected value: " + side);
                    };
                    if (overhangStart > 0 || overhangEnd > 0) {
                        EdgeStyle fillType = EdgeStyle.INNER_FILL;
                        if (overhangStart <= 0) {
                            fillType = EdgeStyle.INNER_FILL_NO_START;
                        } else if (overhangEnd <= 0) {
                            fillType = EdgeStyle.INNER_FILL_NO_END;
                        }
                        tempEdges.add(new Edge(fillType, edgeStart - ourStart + overhangStart, edgeEnd - ourStart - overhangEnd));
                        if (overhangStart <= 0) {
                            this.corners[startCorner] = switch (side) {
                                case 0, 2 -> PanelBlitter.this.LEFT_BORDER;
                                case 1, 3 -> PanelBlitter.this.TOP_BORDER;
                                default -> throw new IllegalStateException("Unexpected value: " + side);
                            };
                        }
                        if (overhangEnd > 0) continue;
                        this.corners[endCorner] = switch (side) {
                            case 0, 2 -> PanelBlitter.this.RIGHT_BORDER;
                            case 1, 3 -> PanelBlitter.this.BOTTOM_BORDER;
                            default -> throw new IllegalStateException("Unexpected value: " + side);
                        };
                        continue;
                    }
                    this.corners[startCorner] = null;
                    this.corners[endCorner] = null;
                    continue;
                }
                tempEdges.add(ourEdge);
            }
            edges.clear();
            edges.addAll(tempEdges);
        }

        public boolean contains(Rectangle rect) {
            int right = rect.x + rect.width;
            int bottom = rect.y + rect.height;
            return rect.x >= this.x && rect.y >= this.y && right <= this.x + this.width && bottom <= this.y + this.height;
        }
    }

    private record Edge(EdgeStyle style, int start, int end) {
        public Edge(int start, int end) {
            this(EdgeStyle.NORMAL, start, end);
        }
    }

    private static enum EdgeStyle {
        NORMAL,
        INNER_FILL,
        INNER_FILL_NO_START,
        INNER_FILL_NO_END;

    }
}

