/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import guideme.libs.micromark.Construct;
import guideme.libs.micromark.ConstructPrecedence;
import guideme.libs.micromark.Extension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Extensions {
    private Extensions() {
    }

    public static Extension combineExtensions(List<Extension> extensions) {
        Extension all = new Extension();
        int index = -1;
        while (++index < extensions.size()) {
            Extensions.syntaxExtension(all, extensions.get(index));
        }
        return all;
    }

    public static void syntaxExtension(Extension all, Extension extension) {
        all.document = Extensions.mergeMap(all.document, extension.document);
        all.contentInitial = Extensions.mergeMap(all.contentInitial, extension.contentInitial);
        all.flowInitial = Extensions.mergeMap(all.flowInitial, extension.flowInitial);
        all.flow = Extensions.mergeMap(all.flow, extension.flow);
        all.string = Extensions.mergeMap(all.string, extension.string);
        all.text = Extensions.mergeMap(all.text, extension.text);
        all.nullDisable.addAll(extension.nullDisable);
        all.nullInsideSpan.addAll(extension.nullInsideSpan);
        all.nullAttentionMarkers.addAll(extension.nullAttentionMarkers);
    }

    private static Map<Integer, List<Construct>> mergeMap(Map<Integer, List<Construct>> left, Map<Integer, List<Construct>> right) {
        left = new HashMap<Integer, List<Construct>>(left);
        for (Integer code : right.keySet()) {
            if (!left.containsKey(code)) {
                left.put(code, List.of());
            }
            left.put(code, Extensions.constructs(left.get(code), right.get(code)));
        }
        return left;
    }

    private static List<Construct> constructs(List<Construct> existing, List<Construct> list) {
        existing = new ArrayList<Construct>(existing);
        int index = -1;
        ArrayList<Construct> before = new ArrayList<Construct>();
        while (++index < list.size()) {
            (list.get((int)index).add == ConstructPrecedence.AFTER ? existing : before).add(list.get(index));
        }
        existing.addAll(0, before);
        return existing;
    }
}

