/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.siteexport;

import com.google.common.hash.Hashing;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class CacheBusting {
    private static final char[] BASE64_SYMBOLS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final BigInteger BASE_62 = BigInteger.valueOf(62L);

    private CacheBusting() {
    }

    public static String create(byte[] content) {
        byte[] contentHash = Hashing.sha256().hashBytes(content).asBytes();
        return CacheBusting.encodeBase62(contentHash).substring(0, 12);
    }

    public static Path writeAsset(Path originalPath, byte[] content) throws IOException {
        String suffix = CacheBusting.create(content);
        Object filename = originalPath.getFileName().toString();
        int idx = ((String)filename).indexOf(46);
        filename = idx == -1 ? (String)filename + "." + suffix : ((String)filename).substring(0, idx) + "." + suffix + ((String)filename).substring(idx);
        Path newPath = originalPath.resolveSibling((String)filename);
        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
        Files.write(newPath, content, new OpenOption[0]);
        return newPath;
    }

    private static String encodeBase62(byte[] data) {
        BigInteger val = new BigInteger(1, data);
        StringBuilder sb = new StringBuilder();
        while (val.compareTo(BigInteger.ZERO) > 0) {
            sb.append(BASE64_SYMBOLS[val.mod(BASE_62).intValue()]);
            val = val.divide(BASE_62);
        }
        return sb.reverse().toString();
    }
}

