/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.intervals;

import guideme.internal.shaded.lucene.queries.intervals.ConjunctionIntervalsSource;
import guideme.internal.shaded.lucene.queries.intervals.ConjunctionMatchesIterator;
import guideme.internal.shaded.lucene.queries.intervals.Disjunctions;
import guideme.internal.shaded.lucene.queries.intervals.FilteringIntervalIterator;
import guideme.internal.shaded.lucene.queries.intervals.IntervalIterator;
import guideme.internal.shaded.lucene.queries.intervals.IntervalMatchesIterator;
import guideme.internal.shaded.lucene.queries.intervals.Intervals;
import guideme.internal.shaded.lucene.queries.intervals.IntervalsSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class ContainedByIntervalsSource
extends ConjunctionIntervalsSource {
    private final IntervalsSource small;
    private final IntervalsSource big;

    static IntervalsSource build(IntervalsSource small, IntervalsSource big) {
        return Intervals.or(Disjunctions.pullUp(big, s -> new ContainedByIntervalsSource(small, (IntervalsSource)s)));
    }

    private ContainedByIntervalsSource(IntervalsSource small, IntervalsSource big) {
        super(Arrays.asList(small, big));
        this.small = small;
        this.big = big;
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators) {
        assert (iterators.size() == 2);
        IntervalIterator a = iterators.get(0);
        IntervalIterator b = iterators.get(1);
        return new FilteringIntervalIterator(this, a, b){

            @Override
            public int nextInterval() throws IOException {
                if (!this.bpos) {
                    return Integer.MAX_VALUE;
                }
                while (this.a.nextInterval() != Integer.MAX_VALUE) {
                    while (this.b.end() < this.a.end()) {
                        if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                        this.bpos = false;
                        return Integer.MAX_VALUE;
                    }
                    if (this.b.start() > this.a.start()) continue;
                    return this.a.start();
                }
                this.bpos = false;
                return Integer.MAX_VALUE;
            }
        };
    }

    @Override
    protected IntervalMatchesIterator createMatchesIterator(IntervalIterator it, List<IntervalMatchesIterator> subs) {
        assert (subs.size() == 2);
        return new ConjunctionMatchesIterator(it, List.of(subs.get(0)));
    }

    @Override
    public int minExtent() {
        return this.small.minExtent();
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(this.big, s -> new ContainedByIntervalsSource(this.small, (IntervalsSource)s));
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ContainedByIntervalsSource)) {
            return false;
        }
        ContainedByIntervalsSource o = (ContainedByIntervalsSource)other;
        return Objects.equals(this.subSources, o.subSources);
    }

    @Override
    public String toString() {
        return "CONTAINED_BY(" + String.valueOf(this.small) + "," + String.valueOf(this.big) + ")";
    }
}

