/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.DocValuesConsumer;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.DocValuesWriter;
import guideme.internal.shaded.lucene.index.DocsWithFieldSet;
import guideme.internal.shaded.lucene.index.EmptyDocValuesProducer;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefArray;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.Counter;
import guideme.internal.shaded.lucene.util.PagedBytes;
import guideme.internal.shaded.lucene.util.packed.PackedLongValues;
import java.io.IOException;

class BinaryDocValuesWriter
extends DocValuesWriter<BinaryDocValues> {
    private static final int MAX_LENGTH = ArrayUtil.MAX_ARRAY_LENGTH;
    private static final int BLOCK_BITS = 12;
    private final PagedBytes bytes;
    private final DataOutput bytesOut;
    private final Counter iwBytesUsed;
    private final PackedLongValues.Builder lengths;
    private DocsWithFieldSet docsWithField;
    private final FieldInfo fieldInfo;
    private long bytesUsed;
    private int lastDocID = -1;
    private int maxLength = 0;
    private PackedLongValues finalLengths;

    BinaryDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.bytes = new PagedBytes(12);
        this.bytesOut = this.bytes.getDataOutput();
        this.lengths = PackedLongValues.deltaPackedBuilder(0.0f);
        this.iwBytesUsed = iwBytesUsed;
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.lengths.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, BytesRef value) {
        if (docID <= this.lastDocID) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        if (value == null) {
            throw new IllegalArgumentException("field=\"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (value.length > MAX_LENGTH) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= " + MAX_LENGTH);
        }
        this.maxLength = Math.max(value.length, this.maxLength);
        this.lengths.add(value.length);
        try {
            this.bytesOut.writeBytes(value.bytes, value.offset, value.length);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.docsWithField.add(docID);
        this.updateBytesUsed();
        this.lastDocID = docID;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.lengths.ramBytesUsed() + this.bytes.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    BinaryDocValues getDocValues() {
        if (this.finalLengths == null) {
            this.finalLengths = this.lengths.build();
        }
        return new BufferedBinaryDocValues(this.finalLengths, this.maxLength, this.bytes.getDataInput(), this.docsWithField.iterator());
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        this.bytes.freeze(false);
        if (this.finalLengths == null) {
            this.finalLengths = this.lengths.build();
        }
        final BinaryDVs sorted = sortMap != null ? new BinaryDVs(state.segmentInfo.maxDoc(), sortMap, new BufferedBinaryDocValues(this.finalLengths, this.maxLength, this.bytes.getDataInput(), this.docsWithField.iterator())) : null;
        dvConsumer.addBinaryField(this.fieldInfo, new EmptyDocValuesProducer(){

            @Override
            public BinaryDocValues getBinary(FieldInfo fieldInfoIn) {
                if (fieldInfoIn != BinaryDocValuesWriter.this.fieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                if (sorted == null) {
                    return new BufferedBinaryDocValues(BinaryDocValuesWriter.this.finalLengths, BinaryDocValuesWriter.this.maxLength, BinaryDocValuesWriter.this.bytes.getDataInput(), BinaryDocValuesWriter.this.docsWithField.iterator());
                }
                return new SortingBinaryDocValues(sorted);
            }
        });
    }

    private static class BufferedBinaryDocValues
    extends BinaryDocValues {
        final BytesRefBuilder value = new BytesRefBuilder();
        final PackedLongValues.Iterator lengthsIterator;
        final DocIdSetIterator docsWithField;
        final DataInput bytesIterator;

        BufferedBinaryDocValues(PackedLongValues lengths, int maxLength, DataInput bytesIterator, DocIdSetIterator docsWithFields) {
            this.value.grow(maxLength);
            this.lengthsIterator = lengths.iterator();
            this.bytesIterator = bytesIterator;
            this.docsWithField = docsWithFields;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                int length = Math.toIntExact(this.lengthsIterator.next());
                this.value.setLength(length);
                this.bytesIterator.readBytes(this.value.bytes(), 0, length);
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public BytesRef binaryValue() {
            return this.value.get();
        }
    }

    static final class BinaryDVs {
        final int[] offsets;
        final BytesRefArray values;

        BinaryDVs(int maxDoc, Sorter.DocMap sortMap, BinaryDocValues oldValues) throws IOException {
            int docID;
            this.offsets = new int[maxDoc];
            this.values = new BytesRefArray(Counter.newCounter());
            int offset = 1;
            while ((docID = oldValues.nextDoc()) != Integer.MAX_VALUE) {
                int newDocID = sortMap.oldToNew(docID);
                this.values.append(oldValues.binaryValue());
                this.offsets[newDocID] = offset++;
            }
        }
    }

    static class SortingBinaryDocValues
    extends BinaryDocValues {
        private final BinaryDVs dvs;
        private final BytesRefBuilder spare = new BytesRefBuilder();
        private int docID = -1;

        SortingBinaryDocValues(BinaryDVs dvs) {
            this.dvs = dvs;
        }

        @Override
        public int nextDoc() {
            do {
                ++this.docID;
                if (this.docID != this.dvs.offsets.length) continue;
                this.docID = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while (this.dvs.offsets[this.docID] <= 0);
            return this.docID;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        public BytesRef binaryValue() {
            this.dvs.values.get(this.spare, this.dvs.offsets[this.docID] - 1);
            return this.spare.get();
        }

        @Override
        public long cost() {
            return this.dvs.values.size();
        }
    }
}

