/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet;

import guideme.internal.shaded.lucene.facet.LabelAndValue;
import java.util.Arrays;

public final class FacetResult {
    public final String dim;
    public final String[] path;
    public final Number value;
    public final int childCount;
    public final LabelAndValue[] labelValues;

    public FacetResult(String dim, String[] path, Number value, LabelAndValue[] labelValues, int childCount) {
        this.dim = dim;
        this.path = path;
        this.value = value;
        this.labelValues = labelValues;
        this.childCount = childCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dim=");
        sb.append(this.dim);
        sb.append(" path=");
        sb.append(Arrays.toString(this.path));
        sb.append(" value=");
        sb.append(this.value);
        sb.append(" childCount=");
        sb.append(this.childCount);
        sb.append('\n');
        for (LabelAndValue labelValue : this.labelValues) {
            sb.append("  ").append(labelValue).append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object _other) {
        if (!(_other instanceof FacetResult)) {
            return false;
        }
        FacetResult other = (FacetResult)_other;
        return this.value.equals(other.value) && this.childCount == other.childCount && Arrays.equals(this.labelValues, other.labelValues);
    }

    public int hashCode() {
        int hashCode = this.value.hashCode() + 31 * this.childCount;
        for (LabelAndValue labelValue : this.labelValues) {
            hashCode = labelValue.hashCode() + 31 * hashCode;
        }
        return hashCode;
    }
}

