/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.XYPointField;
import guideme.internal.shaded.lucene.geo.Component2D;
import guideme.internal.shaded.lucene.geo.XYEncodingUtils;
import guideme.internal.shaded.lucene.geo.XYGeometry;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreWeight;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.DocIdSetBuilder;
import java.io.IOException;
import java.util.Arrays;

final class XYPointInGeometryQuery
extends Query {
    final String field;
    final XYGeometry[] xyGeometries;

    XYPointInGeometryQuery(String field, XYGeometry ... xyGeometries) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (xyGeometries == null) {
            throw new IllegalArgumentException("geometries must not be null");
        }
        if (xyGeometries.length == 0) {
            throw new IllegalArgumentException("geometries must not be empty");
        }
        this.field = field;
        this.xyGeometries = (XYGeometry[])xyGeometries.clone();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result, final Component2D tree) {
        return new PointValues.IntersectVisitor(){
            DocIdSetBuilder.BulkAdder adder;

            @Override
            public void grow(int count) {
                this.adder = result.grow(count);
            }

            @Override
            public void visit(int docID) {
                this.adder.add(docID);
            }

            @Override
            public void visit(DocIdSetIterator iterator) throws IOException {
                this.adder.add(iterator);
            }

            @Override
            public void visit(int docID, byte[] packedValue) {
                double y;
                double x = XYEncodingUtils.decode(packedValue, 0);
                if (tree.contains(x, y = (double)XYEncodingUtils.decode(packedValue, 4))) {
                    this.visit(docID);
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                double y;
                double x = XYEncodingUtils.decode(packedValue, 0);
                if (tree.contains(x, y = (double)XYEncodingUtils.decode(packedValue, 4))) {
                    this.adder.add(iterator);
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                double cellMinX = XYEncodingUtils.decode(minPackedValue, 0);
                double cellMinY = XYEncodingUtils.decode(minPackedValue, 4);
                double cellMaxX = XYEncodingUtils.decode(maxPackedValue, 0);
                double cellMaxY = XYEncodingUtils.decode(maxPackedValue, 4);
                return tree.relate(cellMinX, cellMaxX, cellMinY, cellMaxY);
            }
        };
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Component2D tree = XYGeometry.create(this.xyGeometries);
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(XYPointInGeometryQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(XYPointInGeometryQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                XYPointField.checkCompatible(fieldInfo);
                return new ScorerSupplier(){
                    long cost = -1L;
                    DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    {
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, XYPointInGeometryQuery.this.field);
                        this.visitor = XYPointInGeometryQuery.this.getIntersectVisitor(this.result, tree);
                    }

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        values.intersect(this.visitor);
                        return new ConstantScoreScorer(this.score(), scoreMode, this.result.build().iterator());
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(this.visitor);
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public XYGeometry[] getGeometries() {
        return (XYGeometry[])this.xyGeometries.clone();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Arrays.hashCode(this.xyGeometries);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((XYPointInGeometryQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(XYPointInGeometryQuery other) {
        return this.field.equals(other.field) && Arrays.equals(this.xyGeometries, other.xyGeometries);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(Arrays.toString(this.xyGeometries));
        return sb.toString();
    }
}

