/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene99;

import guideme.internal.shaded.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorScorerUtil;
import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsFormat;
import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsReader;
import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsWriter;
import guideme.internal.shaded.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import guideme.internal.shaded.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorScorer;
import guideme.internal.shaded.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsReader;
import guideme.internal.shaded.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsWriter;
import guideme.internal.shaded.lucene.index.SegmentReadState;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import java.io.IOException;

public class Lucene99ScalarQuantizedVectorsFormat
extends FlatVectorsFormat {
    private static final int ALLOWED_BITS = 144;
    public static final String QUANTIZED_VECTOR_COMPONENT = "QVEC";
    public static final String NAME = "Lucene99ScalarQuantizedVectorsFormat";
    static final int VERSION_START = 0;
    static final int VERSION_ADD_BITS = 1;
    static final int VERSION_CURRENT = 1;
    static final String META_CODEC_NAME = "Lucene99ScalarQuantizedVectorsFormatMeta";
    static final String VECTOR_DATA_CODEC_NAME = "Lucene99ScalarQuantizedVectorsFormatData";
    static final String META_EXTENSION = "vemq";
    static final String VECTOR_DATA_EXTENSION = "veq";
    private static final FlatVectorsFormat rawVectorFormat = new Lucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private static final float MINIMUM_CONFIDENCE_INTERVAL = 0.9f;
    private static final float MAXIMUM_CONFIDENCE_INTERVAL = 1.0f;
    public static final float DYNAMIC_CONFIDENCE_INTERVAL = 0.0f;
    final Float confidenceInterval;
    final byte bits;
    final boolean compress;
    final Lucene99ScalarQuantizedVectorScorer flatVectorScorer;

    public Lucene99ScalarQuantizedVectorsFormat() {
        this(null, 7, false);
    }

    public Lucene99ScalarQuantizedVectorsFormat(Float confidenceInterval, int bits, boolean compress) {
        super(NAME);
        if (confidenceInterval != null && confidenceInterval.floatValue() != 0.0f && (confidenceInterval.floatValue() < 0.9f || confidenceInterval.floatValue() > 1.0f)) {
            throw new IllegalArgumentException("confidenceInterval must be between 0.9 and 1.0 or 0; confidenceInterval=" + confidenceInterval);
        }
        if (bits < 1 || bits > 8 || (0x90 & 1 << bits) == 0) {
            throw new IllegalArgumentException("bits must be one of: 4, 7; bits=" + bits);
        }
        if (bits > 4 && compress) {
            throw new IllegalArgumentException("compress=true only applies when bits=4");
        }
        this.bits = (byte)bits;
        this.confidenceInterval = confidenceInterval;
        this.compress = compress;
        this.flatVectorScorer = new Lucene99ScalarQuantizedVectorScorer(DefaultFlatVectorScorer.INSTANCE);
    }

    public static float calculateDefaultConfidenceInterval(int vectorDimension) {
        return Math.max(0.9f, 1.0f - 1.0f / (float)(vectorDimension + 1));
    }

    public String toString() {
        return "Lucene99ScalarQuantizedVectorsFormat(name=Lucene99ScalarQuantizedVectorsFormat, confidenceInterval=" + this.confidenceInterval + ", bits=" + this.bits + ", compress=" + this.compress + ", flatVectorScorer=" + String.valueOf(this.flatVectorScorer) + ", rawVectorFormat=" + String.valueOf(rawVectorFormat) + ")";
    }

    @Override
    public FlatVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99ScalarQuantizedVectorsWriter(state, this.confidenceInterval, this.bits, this.compress, rawVectorFormat.fieldsWriter(state), this.flatVectorScorer);
    }

    @Override
    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99ScalarQuantizedVectorsReader(state, rawVectorFormat.fieldsReader(state), this.flatVectorScorer);
    }
}

