/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.no;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.no.NorwegianLightStemmer;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.KeywordAttribute;
import java.io.IOException;

public final class NorwegianLightStemFilter
extends TokenFilter {
    private final NorwegianLightStemmer stemmer;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public NorwegianLightStemFilter(TokenStream input) {
        this(input, 1);
    }

    public NorwegianLightStemFilter(TokenStream input, int flags) {
        super(input);
        this.stemmer = new NorwegianLightStemmer(flags);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

