/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.minhash;

import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.minhash.MinHashFilter;
import java.util.Map;

public class MinHashFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "minHash";
    private final int hashCount;
    private final int bucketCount;
    private final int hashSetSize;
    private final boolean withRotation;

    public MinHashFilterFactory(Map<String, String> args) {
        super(args);
        this.hashCount = this.getInt(args, "hashCount", 1);
        this.bucketCount = this.getInt(args, "bucketCount", 512);
        this.hashSetSize = this.getInt(args, "hashSetSize", 1);
        this.withRotation = this.getBoolean(args, "withRotation", this.bucketCount > 1);
    }

    public MinHashFilterFactory() {
        throw MinHashFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new MinHashFilter(input, this.hashCount, this.bucketCount, this.hashSetSize, this.withRotation);
    }
}

